/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.ObserverFullArbiter;
import io.reactivex.internal.observers.FullArbiterObserver;
import io.reactivex.internal.operators.observable.ObservableTimeoutTimed;
import io.reactivex.internal.operators.observable.ObservableTimeoutTimed$TimeoutTimedOtherObserver$SubscribeNext;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableTimeoutTimed$TimeoutTimedOtherObserver<T>
extends AtomicReference<Disposable>
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -4619702551964128179L;
    final Observer<? super T> actual;
    final long timeout;
    final TimeUnit unit;
    final Scheduler$Worker worker;
    final ObservableSource<? extends T> other;
    Disposable s;
    final ObserverFullArbiter<T> arbiter;
    volatile long index;
    volatile boolean done;

    ObservableTimeoutTimed$TimeoutTimedOtherObserver(Observer<? super T> actual, long timeout, TimeUnit unit, Scheduler$Worker worker, ObservableSource<? extends T> other) {
        this.actual = actual;
        this.timeout = timeout;
        this.unit = unit;
        this.worker = worker;
        this.other = other;
        this.arbiter = new ObserverFullArbiter<T>(actual, this, 8);
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            if (this.arbiter.setDisposable(s2)) {
                this.actual.onSubscribe(this.arbiter);
                this.scheduleTimeout(0L);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        long idx;
        if (this.done) {
            return;
        }
        this.index = idx = this.index + 1L;
        if (this.arbiter.onNext(t2, this.s)) {
            this.scheduleTimeout(idx);
        }
    }

    void scheduleTimeout(long idx) {
        Disposable d2 = (Disposable)this.get();
        if (d2 != null) {
            d2.dispose();
        }
        if (this.compareAndSet(d2, ObservableTimeoutTimed.NEW_TIMER)) {
            d2 = this.worker.schedule(new ObservableTimeoutTimed$TimeoutTimedOtherObserver$SubscribeNext(this, idx), this.timeout, this.unit);
            DisposableHelper.replace(this, d2);
        }
    }

    void subscribeNext() {
        this.other.subscribe(new FullArbiterObserver<T>(this.arbiter));
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.arbiter.onError(t2, this.s);
        this.worker.dispose();
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.arbiter.onComplete(this.s);
        this.worker.dispose();
    }

    @Override
    public void dispose() {
        this.s.dispose();
        this.worker.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.worker.isDisposed();
    }
}

