/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;

final class ObservableUsing$UsingObserver<T, D>
extends AtomicBoolean
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = 5904473792286235046L;
    final Observer<? super T> actual;
    final D resource;
    final Consumer<? super D> disposer;
    final boolean eager;
    Disposable s;

    ObservableUsing$UsingObserver(Observer<? super T> actual, D resource, Consumer<? super D> disposer, boolean eager) {
        this.actual = actual;
        this.resource = resource;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        this.actual.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        if (this.eager) {
            if (this.compareAndSet(false, true)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable e2) {
                    Exceptions.throwIfFatal(e2);
                    t2 = new CompositeException(t2, e2);
                }
            }
            this.s.dispose();
            this.actual.onError(t2);
        } else {
            this.actual.onError(t2);
            this.s.dispose();
            this.disposeAfter();
        }
    }

    @Override
    public void onComplete() {
        if (this.eager) {
            if (this.compareAndSet(false, true)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable e2) {
                    Exceptions.throwIfFatal(e2);
                    this.actual.onError(e2);
                    return;
                }
            }
            this.s.dispose();
            this.actual.onComplete();
        } else {
            this.actual.onComplete();
            this.s.dispose();
            this.disposeAfter();
        }
    }

    @Override
    public void dispose() {
        this.disposeAfter();
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.get();
    }

    void disposeAfter() {
        if (this.compareAndSet(false, true)) {
            try {
                this.disposer.accept(this.resource);
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                RxJavaPlugins.onError(e2);
            }
        }
    }
}

