/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableUsing$UsingObserver;
import java.util.concurrent.Callable;

public final class ObservableUsing<T, D>
extends Observable<T> {
    final Callable<? extends D> resourceSupplier;
    final Function<? super D, ? extends ObservableSource<? extends T>> sourceSupplier;
    final Consumer<? super D> disposer;
    final boolean eager;

    public ObservableUsing(Callable<? extends D> resourceSupplier, Function<? super D, ? extends ObservableSource<? extends T>> sourceSupplier, Consumer<? super D> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.sourceSupplier = sourceSupplier;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    public void subscribeActual(Observer<? super T> s2) {
        ObservableSource<T> source;
        D resource;
        try {
            resource = this.resourceSupplier.call();
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            EmptyDisposable.error(e2, s2);
            return;
        }
        try {
            source = ObjectHelper.requireNonNull(this.sourceSupplier.apply(resource), "The sourceSupplier returned a null ObservableSource");
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            try {
                this.disposer.accept(resource);
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                EmptyDisposable.error((Throwable)new CompositeException(e3, ex2), s2);
                return;
            }
            EmptyDisposable.error(e3, s2);
            return;
        }
        ObservableUsing$UsingObserver<? super T, ? super D> us2 = new ObservableUsing$UsingObserver<T, D>(s2, resource, this.disposer, this.eager);
        source.subscribe(us2);
    }
}

