/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.subjects.UnicastSubject;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

final class ObservableWindow$WindowSkipObserver<T>
extends AtomicBoolean
implements Observer<T>,
Disposable,
Runnable {
    private static final long serialVersionUID = 3366976432059579510L;
    final Observer<? super Observable<T>> actual;
    final long count;
    final long skip;
    final int capacityHint;
    final ArrayDeque<UnicastSubject<T>> windows;
    long index;
    volatile boolean cancelled;
    long firstEmission;
    Disposable s;
    final AtomicInteger wip = new AtomicInteger();

    ObservableWindow$WindowSkipObserver(Observer<? super Observable<T>> actual, long count, long skip, int capacityHint) {
        this.actual = actual;
        this.count = count;
        this.skip = skip;
        this.capacityHint = capacityHint;
        this.windows = new ArrayDeque();
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        ArrayDeque<UnicastSubject<T>> ws2 = this.windows;
        long i2 = this.index;
        long s2 = this.skip;
        if (i2 % s2 == 0L && !this.cancelled) {
            this.wip.getAndIncrement();
            UnicastSubject w2 = UnicastSubject.create(this.capacityHint, this);
            ws2.offer(w2);
            this.actual.onNext(w2);
        }
        long c2 = this.firstEmission + 1L;
        for (UnicastSubject<T> w3 : ws2) {
            w3.onNext(t2);
        }
        if (c2 >= this.count) {
            ws2.poll().onComplete();
            if (ws2.isEmpty() && this.cancelled) {
                this.s.dispose();
                return;
            }
            this.firstEmission = c2 - s2;
        } else {
            this.firstEmission = c2;
        }
        this.index = i2 + 1L;
    }

    @Override
    public void onError(Throwable t2) {
        ArrayDeque<UnicastSubject<T>> ws2 = this.windows;
        while (!ws2.isEmpty()) {
            ws2.poll().onError(t2);
        }
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        ArrayDeque<UnicastSubject<T>> ws2 = this.windows;
        while (!ws2.isEmpty()) {
            ws2.poll().onComplete();
        }
        this.actual.onComplete();
    }

    @Override
    public void dispose() {
        this.cancelled = true;
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    @Override
    public void run() {
        if (this.wip.decrementAndGet() == 0 && this.cancelled) {
            this.s.dispose();
        }
    }
}

