/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.operators.observable.ObservableWindowBoundarySupplier$WindowBoundaryInnerObserver;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.UnicastSubject;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableWindowBoundarySupplier$WindowBoundaryMainObserver<T, B>
extends QueueDrainObserver<T, Object, Observable<T>>
implements Disposable {
    final Callable<? extends ObservableSource<B>> other;
    final int bufferSize;
    Disposable s;
    final AtomicReference<Disposable> boundary = new AtomicReference();
    UnicastSubject<T> window;
    static final Object NEXT = new Object();
    final AtomicLong windows = new AtomicLong();

    ObservableWindowBoundarySupplier$WindowBoundaryMainObserver(Observer<? super Observable<T>> actual, Callable<? extends ObservableSource<B>> other, int bufferSize) {
        super(actual, new MpscLinkedQueue());
        this.other = other;
        this.bufferSize = bufferSize;
        this.windows.lazySet(1L);
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            ObservableSource<B> p2;
            this.s = s2;
            Observer a2 = this.actual;
            a2.onSubscribe(this);
            if (this.cancelled) {
                return;
            }
            try {
                p2 = ObjectHelper.requireNonNull(this.other.call(), "The first window ObservableSource supplied is null");
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                s2.dispose();
                a2.onError(e2);
                return;
            }
            UnicastSubject w2 = UnicastSubject.create(this.bufferSize);
            this.window = w2;
            a2.onNext(w2);
            ObservableWindowBoundarySupplier$WindowBoundaryInnerObserver inner = new ObservableWindowBoundarySupplier$WindowBoundaryInnerObserver(this);
            if (this.boundary.compareAndSet(null, inner)) {
                this.windows.getAndIncrement();
                p2.subscribe(inner);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.fastEnter()) {
            UnicastSubject<T> w2 = this.window;
            w2.onNext(t2);
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            this.queue.offer(NotificationLite.next(t2));
            if (!this.enter()) {
                return;
            }
        }
        this.drainLoop();
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.error = t2;
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        if (this.windows.decrementAndGet() == 0L) {
            DisposableHelper.dispose(this.boundary);
        }
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        if (this.windows.decrementAndGet() == 0L) {
            DisposableHelper.dispose(this.boundary);
        }
        this.actual.onComplete();
    }

    @Override
    public void dispose() {
        this.cancelled = true;
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    void drainLoop() {
        MpscLinkedQueue q2 = (MpscLinkedQueue)this.queue;
        Observer a2 = this.actual;
        int missed = 1;
        UnicastSubject w2 = this.window;
        while (true) {
            boolean empty;
            boolean d2 = this.done;
            Object o2 = q2.poll();
            boolean bl2 = empty = o2 == null;
            if (d2 && empty) {
                DisposableHelper.dispose(this.boundary);
                Throwable e2 = this.error;
                if (e2 != null) {
                    w2.onError(e2);
                } else {
                    w2.onComplete();
                }
                return;
            }
            if (!empty) {
                if (o2 == NEXT) {
                    ObservableSource<B> p2;
                    w2.onComplete();
                    if (this.windows.decrementAndGet() == 0L) {
                        DisposableHelper.dispose(this.boundary);
                        return;
                    }
                    if (this.cancelled) continue;
                    try {
                        p2 = ObjectHelper.requireNonNull(this.other.call(), "The ObservableSource supplied is null");
                    }
                    catch (Throwable e3) {
                        Exceptions.throwIfFatal(e3);
                        DisposableHelper.dispose(this.boundary);
                        a2.onError(e3);
                        return;
                    }
                    w2 = UnicastSubject.create(this.bufferSize);
                    this.windows.getAndIncrement();
                    this.window = w2;
                    a2.onNext(w2);
                    ObservableWindowBoundarySupplier$WindowBoundaryInnerObserver b2 = new ObservableWindowBoundarySupplier$WindowBoundaryInnerObserver(this);
                    if (!this.boundary.compareAndSet(this.boundary.get(), b2)) continue;
                    p2.subscribe(b2);
                    continue;
                }
                w2.onNext(NotificationLite.getValue(o2));
                continue;
            }
            if ((missed = this.leave(-missed)) == 0) break;
        }
    }

    void next() {
        this.queue.offer(NEXT);
        if (this.enter()) {
            this.drainLoop();
        }
    }
}

