/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.operators.observable.ObservableWindowTimed$WindowExactBoundedObserver$ConsumerIndexHolder;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.subjects.UnicastSubject;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableWindowTimed$WindowExactBoundedObserver<T>
extends QueueDrainObserver<T, Object, Observable<T>>
implements Disposable {
    final long timespan;
    final TimeUnit unit;
    final Scheduler scheduler;
    final int bufferSize;
    final boolean restartTimerOnMaxSize;
    final long maxSize;
    final Scheduler$Worker worker;
    long count;
    long producerIndex;
    Disposable s;
    UnicastSubject<T> window;
    volatile boolean terminated;
    final AtomicReference<Disposable> timer = new AtomicReference();

    ObservableWindowTimed$WindowExactBoundedObserver(Observer<? super Observable<T>> actual, long timespan, TimeUnit unit, Scheduler scheduler, int bufferSize, long maxSize, boolean restartTimerOnMaxSize) {
        super(actual, new MpscLinkedQueue());
        this.timespan = timespan;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSize = bufferSize;
        this.maxSize = maxSize;
        this.restartTimerOnMaxSize = restartTimerOnMaxSize;
        this.worker = restartTimerOnMaxSize ? scheduler.createWorker() : null;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            Observer a2 = this.actual;
            a2.onSubscribe(this);
            if (this.cancelled) {
                return;
            }
            UnicastSubject w2 = UnicastSubject.create(this.bufferSize);
            this.window = w2;
            a2.onNext(w2);
            ObservableWindowTimed$WindowExactBoundedObserver$ConsumerIndexHolder consumerIndexHolder = new ObservableWindowTimed$WindowExactBoundedObserver$ConsumerIndexHolder(this.producerIndex, this);
            Disposable d2 = this.restartTimerOnMaxSize ? this.worker.schedulePeriodically(consumerIndexHolder, this.timespan, this.timespan, this.unit) : this.scheduler.schedulePeriodicallyDirect(consumerIndexHolder, this.timespan, this.timespan, this.unit);
            DisposableHelper.replace(this.timer, d2);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.terminated) {
            return;
        }
        if (this.fastEnter()) {
            UnicastSubject<T> w2 = this.window;
            w2.onNext(t2);
            long c2 = this.count + 1L;
            if (c2 >= this.maxSize) {
                ++this.producerIndex;
                this.count = 0L;
                w2.onComplete();
                w2 = UnicastSubject.create(this.bufferSize);
                this.window = w2;
                this.actual.onNext(w2);
                if (this.restartTimerOnMaxSize) {
                    Disposable tm2 = this.timer.get();
                    tm2.dispose();
                    Disposable task = this.worker.schedulePeriodically(new ObservableWindowTimed$WindowExactBoundedObserver$ConsumerIndexHolder(this.producerIndex, this), this.timespan, this.timespan, this.unit);
                    DisposableHelper.replace(this.timer, task);
                }
            } else {
                this.count = c2;
            }
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            this.queue.offer(NotificationLite.next(t2));
            if (!this.enter()) {
                return;
            }
        }
        this.drainLoop();
    }

    @Override
    public void onError(Throwable t2) {
        this.error = t2;
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        this.actual.onError(t2);
        this.disposeTimer();
    }

    @Override
    public void onComplete() {
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        this.actual.onComplete();
        this.disposeTimer();
    }

    @Override
    public void dispose() {
        this.cancelled = true;
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    void disposeTimer() {
        DisposableHelper.dispose(this.timer);
        Scheduler$Worker w2 = this.worker;
        if (w2 != null) {
            w2.dispose();
        }
    }

    void drainLoop() {
        MpscLinkedQueue q2 = (MpscLinkedQueue)this.queue;
        Observer a2 = this.actual;
        UnicastSubject w2 = this.window;
        int missed = 1;
        while (true) {
            if (this.terminated) {
                this.s.dispose();
                q2.clear();
                this.disposeTimer();
                return;
            }
            boolean d2 = this.done;
            Object o2 = q2.poll();
            boolean empty = o2 == null;
            boolean isHolder = o2 instanceof ObservableWindowTimed$WindowExactBoundedObserver$ConsumerIndexHolder;
            if (d2 && (empty || isHolder)) {
                this.window = null;
                q2.clear();
                this.disposeTimer();
                Throwable err = this.error;
                if (err != null) {
                    w2.onError(err);
                } else {
                    w2.onComplete();
                }
                return;
            }
            if (!empty) {
                if (isHolder) {
                    ObservableWindowTimed$WindowExactBoundedObserver$ConsumerIndexHolder consumerIndexHolder = (ObservableWindowTimed$WindowExactBoundedObserver$ConsumerIndexHolder)o2;
                    if (!this.restartTimerOnMaxSize && this.producerIndex != consumerIndexHolder.index) continue;
                    w2.onComplete();
                    this.count = 0L;
                    w2 = UnicastSubject.create(this.bufferSize);
                    this.window = w2;
                    a2.onNext(w2);
                    continue;
                }
                w2.onNext(NotificationLite.getValue(o2));
                long c2 = this.count + 1L;
                if (c2 >= this.maxSize) {
                    ++this.producerIndex;
                    this.count = 0L;
                    w2.onComplete();
                    w2 = UnicastSubject.create(this.bufferSize);
                    this.window = w2;
                    this.actual.onNext(w2);
                    if (!this.restartTimerOnMaxSize) continue;
                    Disposable tm2 = this.timer.get();
                    tm2.dispose();
                    Disposable task = this.worker.schedulePeriodically(new ObservableWindowTimed$WindowExactBoundedObserver$ConsumerIndexHolder(this.producerIndex, this), this.timespan, this.timespan, this.unit);
                    if (this.timer.compareAndSet(tm2, task)) continue;
                    task.dispose();
                    continue;
                }
                this.count = c2;
                continue;
            }
            if ((missed = this.leave(-missed)) == 0) break;
        }
    }

    static /* synthetic */ boolean access$000(ObservableWindowTimed$WindowExactBoundedObserver x0) {
        return x0.cancelled;
    }

    static /* synthetic */ SimplePlainQueue access$100(ObservableWindowTimed$WindowExactBoundedObserver x0) {
        return x0.queue;
    }
}

