/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.subjects.UnicastSubject;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableWindowTimed$WindowExactUnboundedObserver<T>
extends QueueDrainObserver<T, Object, Observable<T>>
implements Observer<T>,
Disposable,
Runnable {
    final long timespan;
    final TimeUnit unit;
    final Scheduler scheduler;
    final int bufferSize;
    Disposable s;
    UnicastSubject<T> window;
    final AtomicReference<Disposable> timer = new AtomicReference();
    static final Object NEXT = new Object();
    volatile boolean terminated;

    ObservableWindowTimed$WindowExactUnboundedObserver(Observer<? super Observable<T>> actual, long timespan, TimeUnit unit, Scheduler scheduler, int bufferSize) {
        super(actual, new MpscLinkedQueue());
        this.timespan = timespan;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSize = bufferSize;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.window = UnicastSubject.create(this.bufferSize);
            Observer a2 = this.actual;
            a2.onSubscribe(this);
            a2.onNext(this.window);
            if (!this.cancelled) {
                Disposable d2 = this.scheduler.schedulePeriodicallyDirect(this, this.timespan, this.timespan, this.unit);
                DisposableHelper.replace(this.timer, d2);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.terminated) {
            return;
        }
        if (this.fastEnter()) {
            this.window.onNext(t2);
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            this.queue.offer(NotificationLite.next(t2));
            if (!this.enter()) {
                return;
            }
        }
        this.drainLoop();
    }

    @Override
    public void onError(Throwable t2) {
        this.error = t2;
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        this.disposeTimer();
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        this.disposeTimer();
        this.actual.onComplete();
    }

    @Override
    public void dispose() {
        this.cancelled = true;
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    void disposeTimer() {
        DisposableHelper.dispose(this.timer);
    }

    @Override
    public void run() {
        if (this.cancelled) {
            this.terminated = true;
            this.disposeTimer();
        }
        this.queue.offer(NEXT);
        if (this.enter()) {
            this.drainLoop();
        }
    }

    void drainLoop() {
        MpscLinkedQueue q2 = (MpscLinkedQueue)this.queue;
        Observer a2 = this.actual;
        UnicastSubject w2 = this.window;
        int missed = 1;
        while (true) {
            boolean term = this.terminated;
            boolean d2 = this.done;
            Object o2 = q2.poll();
            if (d2 && (o2 == null || o2 == NEXT)) {
                this.window = null;
                q2.clear();
                this.disposeTimer();
                Throwable err = this.error;
                if (err != null) {
                    w2.onError(err);
                } else {
                    w2.onComplete();
                }
                return;
            }
            if (o2 != null) {
                if (o2 == NEXT) {
                    w2.onComplete();
                    if (!term) {
                        w2 = UnicastSubject.create(this.bufferSize);
                        this.window = w2;
                        a2.onNext(w2);
                        continue;
                    }
                    this.s.dispose();
                    continue;
                }
                w2.onNext(NotificationLite.getValue(o2));
                continue;
            }
            if ((missed = this.leave(-missed)) == 0) break;
        }
    }
}

