/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableWithLatestFromMany$WithLatestInnerObserver;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.HalfSerializer;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

final class ObservableWithLatestFromMany$WithLatestFromObserver<T, R>
extends AtomicInteger
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = 1577321883966341961L;
    final Observer<? super R> actual;
    final Function<? super Object[], R> combiner;
    final ObservableWithLatestFromMany$WithLatestInnerObserver[] observers;
    final AtomicReferenceArray<Object> values;
    final AtomicReference<Disposable> d;
    final AtomicThrowable error;
    volatile boolean done;

    ObservableWithLatestFromMany$WithLatestFromObserver(Observer<? super R> actual, Function<? super Object[], R> combiner, int n2) {
        this.actual = actual;
        this.combiner = combiner;
        ObservableWithLatestFromMany$WithLatestInnerObserver[] s2 = new ObservableWithLatestFromMany$WithLatestInnerObserver[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            s2[i2] = new ObservableWithLatestFromMany$WithLatestInnerObserver(this, i2);
        }
        this.observers = s2;
        this.values = new AtomicReferenceArray(n2);
        this.d = new AtomicReference();
        this.error = new AtomicThrowable();
    }

    void subscribe(ObservableSource<?>[] others, int n2) {
        ObservableWithLatestFromMany$WithLatestInnerObserver[] observers = this.observers;
        AtomicReference<Disposable> s2 = this.d;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (DisposableHelper.isDisposed(s2.get()) || this.done) {
                return;
            }
            others[i2].subscribe(observers[i2]);
        }
    }

    @Override
    public void onSubscribe(Disposable d2) {
        DisposableHelper.setOnce(this.d, d2);
    }

    @Override
    public void onNext(T t2) {
        R v2;
        if (this.done) {
            return;
        }
        AtomicReferenceArray<Object> ara = this.values;
        int n2 = ara.length();
        Object[] objects = new Object[n2 + 1];
        objects[0] = t2;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object o2 = ara.get(i2);
            if (o2 == null) {
                return;
            }
            objects[i2 + 1] = o2;
        }
        try {
            v2 = ObjectHelper.requireNonNull(this.combiner.apply((Object[])objects), "combiner returned a null value");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.dispose();
            this.onError(ex2);
            return;
        }
        HalfSerializer.onNext(this.actual, v2, (AtomicInteger)this, this.error);
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.cancelAllBut(-1);
        HalfSerializer.onError(this.actual, t2, (AtomicInteger)this, this.error);
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            this.cancelAllBut(-1);
            HalfSerializer.onComplete(this.actual, (AtomicInteger)this, this.error);
        }
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed(this.d.get());
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this.d);
        for (ObservableWithLatestFromMany$WithLatestInnerObserver s2 : this.observers) {
            s2.dispose();
        }
    }

    void innerNext(int index, Object o2) {
        this.values.set(index, o2);
    }

    void innerError(int index, Throwable t2) {
        this.done = true;
        DisposableHelper.dispose(this.d);
        this.cancelAllBut(index);
        HalfSerializer.onError(this.actual, t2, (AtomicInteger)this, this.error);
    }

    void innerComplete(int index, boolean nonEmpty) {
        if (!nonEmpty) {
            this.done = true;
            this.cancelAllBut(index);
            HalfSerializer.onComplete(this.actual, (AtomicInteger)this, this.error);
        }
    }

    void cancelAllBut(int index) {
        ObservableWithLatestFromMany$WithLatestInnerObserver[] observers = this.observers;
        for (int i2 = 0; i2 < observers.length; ++i2) {
            if (i2 == index) continue;
            observers[i2].dispose();
        }
    }
}

