/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.operators.observable.ObservableMap;
import io.reactivex.internal.operators.observable.ObservableWithLatestFromMany$SingletonArrayFunc;
import io.reactivex.internal.operators.observable.ObservableWithLatestFromMany$WithLatestFromObserver;
import java.util.Arrays;

public final class ObservableWithLatestFromMany<T, R>
extends AbstractObservableWithUpstream<T, R> {
    @Nullable
    final ObservableSource<?>[] otherArray;
    @Nullable
    final Iterable<? extends ObservableSource<?>> otherIterable;
    @NonNull
    final Function<? super Object[], R> combiner;

    public ObservableWithLatestFromMany(@NonNull ObservableSource<T> source, @NonNull ObservableSource<?>[] otherArray, @NonNull Function<? super Object[], R> combiner) {
        super(source);
        this.otherArray = otherArray;
        this.otherIterable = null;
        this.combiner = combiner;
    }

    public ObservableWithLatestFromMany(@NonNull ObservableSource<T> source, @NonNull Iterable<? extends ObservableSource<?>> otherIterable, @NonNull Function<? super Object[], R> combiner) {
        super(source);
        this.otherArray = null;
        this.otherIterable = otherIterable;
        this.combiner = combiner;
    }

    @Override
    public void subscribeActual(Observer<? super R> s2) {
        ObservableSource<?>[] others = this.otherArray;
        int n2 = 0;
        if (others == null) {
            others = new ObservableSource[8];
            try {
                for (ObservableSource<?> p2 : this.otherIterable) {
                    if (n2 == others.length) {
                        others = Arrays.copyOf(others, n2 + (n2 >> 1));
                    }
                    others[n2++] = p2;
                }
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                EmptyDisposable.error(ex2, s2);
                return;
            }
        } else {
            n2 = others.length;
        }
        if (n2 == 0) {
            new ObservableMap(this.source, new ObservableWithLatestFromMany$SingletonArrayFunc(this)).subscribeActual(s2);
            return;
        }
        ObservableWithLatestFromMany$WithLatestFromObserver parent = new ObservableWithLatestFromMany$WithLatestFromObserver(s2, this.combiner, n2);
        s2.onSubscribe(parent);
        parent.subscribe(others, n2);
        this.source.subscribe(parent);
    }
}

