/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableZip$ZipObserver;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

final class ObservableZip$ZipCoordinator<T, R>
extends AtomicInteger
implements Disposable {
    private static final long serialVersionUID = 2983708048395377667L;
    final Observer<? super R> actual;
    final Function<? super Object[], ? extends R> zipper;
    final ObservableZip$ZipObserver<T, R>[] observers;
    final T[] row;
    final boolean delayError;
    volatile boolean cancelled;

    ObservableZip$ZipCoordinator(Observer<? super R> actual, Function<? super Object[], ? extends R> zipper, int count, boolean delayError) {
        this.actual = actual;
        this.zipper = zipper;
        this.observers = new ObservableZip$ZipObserver[count];
        this.row = new Object[count];
        this.delayError = delayError;
    }

    public void subscribe(ObservableSource<? extends T>[] sources, int bufferSize) {
        int i2;
        ObservableZip$ZipObserver<T, R>[] s2 = this.observers;
        int len = s2.length;
        for (i2 = 0; i2 < len; ++i2) {
            s2[i2] = new ObservableZip$ZipObserver(this, bufferSize);
        }
        this.lazySet(0);
        this.actual.onSubscribe(this);
        for (i2 = 0; i2 < len; ++i2) {
            if (this.cancelled) {
                return;
            }
            sources[i2].subscribe(s2[i2]);
        }
    }

    @Override
    public void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.cancelSources();
            if (this.getAndIncrement() == 0) {
                this.clear();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    void cancel() {
        this.clear();
        this.cancelSources();
    }

    void cancelSources() {
        for (ObservableZip$ZipObserver<T, R> zs2 : this.observers) {
            zs2.dispose();
        }
    }

    void clear() {
        for (ObservableZip$ZipObserver<T, R> zs2 : this.observers) {
            zs2.queue.clear();
        }
    }

    public void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missing = 1;
        ObservableZip$ZipObserver<T, R>[] zs2 = this.observers;
        Observer<R> a2 = this.actual;
        Object[] os2 = this.row;
        boolean delayError = this.delayError;
        while (true) {
            int i2 = 0;
            int emptyCount = 0;
            for (ObservableZip$ZipObserver<T, R> z2 : zs2) {
                Throwable ex2;
                if (os2[i2] == null) {
                    boolean empty;
                    boolean d2 = z2.done;
                    Object v2 = z2.queue.poll();
                    boolean bl2 = empty = v2 == null;
                    if (this.checkTerminated(d2, empty, a2, delayError, z2)) {
                        return;
                    }
                    if (!empty) {
                        os2[i2] = v2;
                    } else {
                        ++emptyCount;
                    }
                } else if (z2.done && !delayError && (ex2 = z2.error) != null) {
                    this.cancel();
                    a2.onError(ex2);
                    return;
                }
                ++i2;
            }
            if (emptyCount == 0) {
                R v3;
                try {
                    v3 = ObjectHelper.requireNonNull(this.zipper.apply((Object[])os2.clone()), "The zipper returned a null value");
                }
                catch (Throwable ex3) {
                    Exceptions.throwIfFatal(ex3);
                    this.cancel();
                    a2.onError(ex3);
                    return;
                }
                a2.onNext(v3);
                Arrays.fill(os2, null);
                continue;
            }
            if ((missing = this.addAndGet(-missing)) == 0) break;
        }
    }

    boolean checkTerminated(boolean d2, boolean empty, Observer<? super R> a2, boolean delayError, ObservableZip$ZipObserver<?, ?> source) {
        if (this.cancelled) {
            this.cancel();
            return true;
        }
        if (d2) {
            if (delayError) {
                if (empty) {
                    Throwable e2 = source.error;
                    this.cancel();
                    if (e2 != null) {
                        a2.onError(e2);
                    } else {
                        a2.onComplete();
                    }
                    return true;
                }
            } else {
                Throwable e3 = source.error;
                if (e3 != null) {
                    this.cancel();
                    a2.onError(e3);
                    return true;
                }
                if (empty) {
                    this.cancel();
                    a2.onComplete();
                    return true;
                }
            }
        }
        return false;
    }
}

