/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.observable.ObservableZip$ZipCoordinator;

public final class ObservableZip<T, R>
extends Observable<R> {
    final ObservableSource<? extends T>[] sources;
    final Iterable<? extends ObservableSource<? extends T>> sourcesIterable;
    final Function<? super Object[], ? extends R> zipper;
    final int bufferSize;
    final boolean delayError;

    public ObservableZip(ObservableSource<? extends T>[] sources, Iterable<? extends ObservableSource<? extends T>> sourcesIterable, Function<? super Object[], ? extends R> zipper, int bufferSize, boolean delayError) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
        this.zipper = zipper;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Observer<? super R> s2) {
        ObservableSource<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new Observable[8];
            for (ObservableSource<? extends T> observableSource : this.sourcesIterable) {
                if (count == sources.length) {
                    ObservableSource[] b2 = new ObservableSource[count + (count >> 2)];
                    System.arraycopy(sources, 0, b2, 0, count);
                    sources = b2;
                }
                sources[count++] = observableSource;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptyDisposable.complete(s2);
            return;
        }
        ObservableZip$ZipCoordinator<? extends T, R> zc2 = new ObservableZip$ZipCoordinator<T, R>(s2, this.zipper, count, this.delayError);
        zc2.subscribe(sources, this.bufferSize);
    }
}

