/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;

final class ObservableZipIterable$ZipIterableObserver<T, U, V>
implements Observer<T>,
Disposable {
    final Observer<? super V> actual;
    final Iterator<U> iterator;
    final BiFunction<? super T, ? super U, ? extends V> zipper;
    Disposable s;
    boolean done;

    ObservableZipIterable$ZipIterableObserver(Observer<? super V> actual, Iterator<U> iterator, BiFunction<? super T, ? super U, ? extends V> zipper) {
        this.actual = actual;
        this.iterator = iterator;
        this.zipper = zipper;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void onNext(T t2) {
        boolean b2;
        V v2;
        U u2;
        if (this.done) {
            return;
        }
        try {
            u2 = ObjectHelper.requireNonNull(this.iterator.next(), "The iterator returned a null value");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.error(e2);
            return;
        }
        try {
            v2 = ObjectHelper.requireNonNull(this.zipper.apply(t2, u2), "The zipper function returned a null value");
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            this.error(e3);
            return;
        }
        this.actual.onNext(v2);
        try {
            b2 = this.iterator.hasNext();
        }
        catch (Throwable e4) {
            Exceptions.throwIfFatal(e4);
            this.error(e4);
            return;
        }
        if (!b2) {
            this.done = true;
            this.s.dispose();
            this.actual.onComplete();
        }
    }

    void error(Throwable e2) {
        this.done = true;
        this.s.dispose();
        this.actual.onError(e2);
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
    }
}

