/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiConsumer;
import io.reactivex.internal.subscribers.DeferredScalarSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class ParallelCollect$ParallelCollectSubscriber<T, C>
extends DeferredScalarSubscriber<T, C> {
    private static final long serialVersionUID = -4767392946044436228L;
    final BiConsumer<? super C, ? super T> collector;
    C collection;
    boolean done;

    ParallelCollect$ParallelCollectSubscriber(Yx<? super C> subscriber, C initialValue, BiConsumer<? super C, ? super T> collector) {
        super(subscriber);
        this.collection = initialValue;
        this.collector = collector;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        try {
            this.collector.accept(this.collection, t2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.cancel();
            this.onError(ex2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.collection = null;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        C c2 = this.collection;
        this.collection = null;
        this.complete(c2);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.s.cancel();
    }
}

