/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiConsumer;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.parallel.ParallelCollect$ParallelCollectSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.parallel.ParallelFlowable;
import java.util.concurrent.Callable;

public final class ParallelCollect<T, C>
extends ParallelFlowable<C> {
    final ParallelFlowable<? extends T> source;
    final Callable<? extends C> initialCollection;
    final BiConsumer<? super C, ? super T> collector;

    public ParallelCollect(ParallelFlowable<? extends T> source, Callable<? extends C> initialCollection, BiConsumer<? super C, ? super T> collector) {
        this.source = source;
        this.initialCollection = initialCollection;
        this.collector = collector;
    }

    @Override
    public void subscribe(Yx<? super C>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n2 = subscribers.length;
        Yx[] parents = new Yx[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            C initialValue;
            try {
                initialValue = ObjectHelper.requireNonNull(this.initialCollection.call(), "The initialSupplier returned a null value");
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.reportError(subscribers, ex2);
                return;
            }
            parents[i2] = new ParallelCollect$ParallelCollectSubscriber<T, C>(subscribers[i2], initialValue, this.collector);
        }
        this.source.subscribe(parents);
    }

    void reportError(Yx<?>[] subscribers, Throwable ex2) {
        for (Yx<?> s2 : subscribers) {
            EmptySubscription.error(ex2, s2);
        }
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }
}

