/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableConcatMap;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.parallel.ParallelFlowable;

public final class ParallelConcatMap<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<T> source;
    final Function<? super T, ? extends Yw<? extends R>> mapper;
    final int prefetch;
    final ErrorMode errorMode;

    public ParallelConcatMap(ParallelFlowable<T> source, Function<? super T, ? extends Yw<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
        this.source = source;
        this.mapper = ObjectHelper.requireNonNull(mapper, "mapper");
        this.prefetch = prefetch;
        this.errorMode = ObjectHelper.requireNonNull(errorMode, "errorMode");
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public void subscribe(Yx<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n2 = subscribers.length;
        Yx[] parents = new Yx[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            parents[i2] = FlowableConcatMap.subscribe(subscribers[i2], this.mapper, this.prefetch, this.errorMode);
        }
        this.source.subscribe(parents);
    }
}

