/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.operators.parallel.ParallelFilter$BaseFilterSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class ParallelFilter$ParallelFilterConditionalSubscriber<T>
extends ParallelFilter$BaseFilterSubscriber<T> {
    final ConditionalSubscriber<? super T> actual;

    ParallelFilter$ParallelFilterConditionalSubscriber(ConditionalSubscriber<? super T> actual, Predicate<? super T> predicate) {
        super(predicate);
        this.actual = actual;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public boolean tryOnNext(T t2) {
        if (!this.done) {
            boolean b2;
            try {
                b2 = this.predicate.test(t2);
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.cancel();
                this.onError(ex2);
                return false;
            }
            if (b2) {
                return this.actual.tryOnNext(t2);
            }
        }
        return false;
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            this.actual.onComplete();
        }
    }
}

