/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.operators.parallel.ParallelFilterTry$BaseFilterSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.parallel.ParallelFailureHandling;
import io.reactivex.plugins.RxJavaPlugins;

final class ParallelFilterTry$ParallelFilterConditionalSubscriber<T>
extends ParallelFilterTry$BaseFilterSubscriber<T> {
    final ConditionalSubscriber<? super T> actual;

    ParallelFilterTry$ParallelFilterConditionalSubscriber(ConditionalSubscriber<? super T> actual, Predicate<? super T> predicate, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        super(predicate, errorHandler);
        this.actual = actual;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public boolean tryOnNext(T t2) {
        if (!this.done) {
            boolean b2;
            long retries = 0L;
            block9: while (true) {
                try {
                    b2 = this.predicate.test(t2);
                }
                catch (Throwable ex2) {
                    ParallelFailureHandling h2;
                    Exceptions.throwIfFatal(ex2);
                    try {
                        h2 = (ParallelFailureHandling)ObjectHelper.requireNonNull(this.errorHandler.apply(++retries, ex2), "The errorHandler returned a null item");
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal(exc);
                        this.cancel();
                        this.onError(new CompositeException(ex2, exc));
                        return false;
                    }
                    switch (h2) {
                        case RETRY: {
                            continue block9;
                        }
                        case SKIP: {
                            return false;
                        }
                        case STOP: {
                            this.cancel();
                            this.onComplete();
                            return false;
                        }
                    }
                    this.cancel();
                    this.onError(ex2);
                    return false;
                }
                break;
            }
            return b2 && this.actual.tryOnNext(t2);
        }
        return false;
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            this.actual.onComplete();
        }
    }
}

