/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.functions.Function;
import io.reactivex.internal.operators.flowable.FlowableFlatMap;
import io.reactivex.parallel.ParallelFlowable;

public final class ParallelFlatMap<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<T> source;
    final Function<? super T, ? extends Yw<? extends R>> mapper;
    final boolean delayError;
    final int maxConcurrency;
    final int prefetch;

    public ParallelFlatMap(ParallelFlowable<T> source, Function<? super T, ? extends Yw<? extends R>> mapper, boolean delayError, int maxConcurrency, int prefetch) {
        this.source = source;
        this.mapper = mapper;
        this.delayError = delayError;
        this.maxConcurrency = maxConcurrency;
        this.prefetch = prefetch;
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public void subscribe(Yx<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n2 = subscribers.length;
        Yx[] parents = new Yx[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            parents[i2] = FlowableFlatMap.subscribe(subscribers[i2], this.mapper, this.delayError, this.maxConcurrency, this.prefetch);
        }
        this.source.subscribe(parents);
    }
}

