/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.internal.operators.parallel.ParallelJoin$JoinInnerSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

abstract class ParallelJoin$JoinSubscriptionBase<T>
extends AtomicInteger
implements Yy {
    private static final long serialVersionUID = 3100232009247827843L;
    final Yx<? super T> actual;
    final ParallelJoin$JoinInnerSubscriber<T>[] subscribers;
    final AtomicThrowable errors = new AtomicThrowable();
    final AtomicLong requested = new AtomicLong();
    volatile boolean cancelled;
    final AtomicInteger done = new AtomicInteger();

    ParallelJoin$JoinSubscriptionBase(Yx<? super T> actual, int n2, int prefetch) {
        this.actual = actual;
        ParallelJoin$JoinInnerSubscriber[] a2 = new ParallelJoin$JoinInnerSubscriber[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            a2[i2] = new ParallelJoin$JoinInnerSubscriber(this, prefetch);
        }
        this.subscribers = a2;
        this.done.lazySet(n2);
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.cancelAll();
            if (this.getAndIncrement() == 0) {
                this.cleanup();
            }
        }
    }

    void cancelAll() {
        for (int i2 = 0; i2 < this.subscribers.length; ++i2) {
            ParallelJoin$JoinInnerSubscriber<T> s2 = this.subscribers[i2];
            s2.cancel();
        }
    }

    void cleanup() {
        for (int i2 = 0; i2 < this.subscribers.length; ++i2) {
            ParallelJoin$JoinInnerSubscriber<T> s2 = this.subscribers[i2];
            s2.queue = null;
        }
    }

    abstract void onNext(ParallelJoin$JoinInnerSubscriber<T> var1, T var2);

    abstract void onError(Throwable var1);

    abstract void onComplete();

    abstract void drain();
}

