/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.operators.parallel.ParallelJoin$JoinInnerSubscriber;
import io.reactivex.internal.operators.parallel.ParallelJoin$JoinSubscriptionBase;

final class ParallelJoin$JoinSubscriptionDelayError<T>
extends ParallelJoin$JoinSubscriptionBase<T> {
    private static final long serialVersionUID = -5737965195918321883L;

    ParallelJoin$JoinSubscriptionDelayError(Yx<? super T> actual, int n2, int prefetch) {
        super(actual, n2, prefetch);
    }

    @Override
    void onNext(ParallelJoin$JoinInnerSubscriber<T> inner, T value) {
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            if (this.requested.get() != 0L) {
                this.actual.onNext(value);
                if (this.requested.get() != Long.MAX_VALUE) {
                    this.requested.decrementAndGet();
                }
                inner.request(1L);
            } else {
                SimplePlainQueue<T> q2 = inner.getQueue();
                if (!q2.offer(value)) {
                    inner.cancel();
                    this.errors.addThrowable(new MissingBackpressureException("Queue full?!"));
                    this.done.decrementAndGet();
                    this.drainLoop();
                    return;
                }
            }
            if (this.decrementAndGet() == 0) {
                return;
            }
        } else {
            SimplePlainQueue<T> q3 = inner.getQueue();
            if (!q3.offer(value) && inner.cancel()) {
                this.errors.addThrowable(new MissingBackpressureException("Queue full?!"));
                this.done.decrementAndGet();
            }
            if (this.getAndIncrement() != 0) {
                return;
            }
        }
        this.drainLoop();
    }

    @Override
    void onError(Throwable e2) {
        this.errors.addThrowable(e2);
        this.done.decrementAndGet();
        this.drain();
    }

    @Override
    void onComplete() {
        this.done.decrementAndGet();
        this.drain();
    }

    @Override
    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        this.drainLoop();
    }

    void drainLoop() {
        int missed = 1;
        ParallelJoin$JoinInnerSubscriber[] s2 = this.subscribers;
        int n2 = s2.length;
        Yx a2 = this.actual;
        while (true) {
            int w2;
            SimplePlainQueue q2;
            ParallelJoin$JoinInnerSubscriber inner;
            int i2;
            boolean empty;
            boolean d2;
            long r2 = this.requested.get();
            long e2 = 0L;
            block1: while (e2 != r2) {
                if (this.cancelled) {
                    this.cleanup();
                    return;
                }
                d2 = this.done.get() == 0;
                empty = true;
                for (i2 = 0; i2 < n2; ++i2) {
                    Object v2;
                    inner = s2[i2];
                    q2 = inner.queue;
                    if (q2 == null || (v2 = q2.poll()) == null) continue;
                    empty = false;
                    a2.onNext(v2);
                    inner.requestOne();
                    if (++e2 == r2) break block1;
                }
                if (d2 && empty) {
                    Throwable ex2 = (Throwable)this.errors.get();
                    if (ex2 != null) {
                        a2.onError(this.errors.terminate());
                    } else {
                        a2.onComplete();
                    }
                    return;
                }
                if (!empty) continue;
                break;
            }
            if (e2 == r2) {
                if (this.cancelled) {
                    this.cleanup();
                    return;
                }
                d2 = this.done.get() == 0;
                empty = true;
                for (i2 = 0; i2 < n2; ++i2) {
                    inner = s2[i2];
                    q2 = inner.queue;
                    if (q2 == null || q2.isEmpty()) continue;
                    empty = false;
                    break;
                }
                if (d2 && empty) {
                    Throwable ex3 = (Throwable)this.errors.get();
                    if (ex3 != null) {
                        a2.onError(this.errors.terminate());
                    } else {
                        a2.onComplete();
                    }
                    return;
                }
            }
            if (e2 != 0L && r2 != Long.MAX_VALUE) {
                this.requested.addAndGet(-e2);
            }
            if ((w2 = this.get()) == missed) {
                if ((missed = this.addAndGet(-missed)) != 0) continue;
                break;
            }
            missed = w2;
        }
    }
}

