/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class ParallelMap$ParallelMapSubscriber<T, R>
implements Yy,
FlowableSubscriber<T> {
    final Yx<? super R> actual;
    final Function<? super T, ? extends R> mapper;
    Yy s;
    boolean done;

    ParallelMap$ParallelMapSubscriber(Yx<? super R> actual, Function<? super T, ? extends R> mapper) {
        this.actual = actual;
        this.mapper = mapper;
    }

    @Override
    public void request(long n2) {
        this.s.request(n2);
    }

    @Override
    public void cancel() {
        this.s.cancel();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        R v2;
        if (this.done) {
            return;
        }
        try {
            v2 = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper returned a null value");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.cancel();
            this.onError(ex2);
            return;
        }
        this.actual.onNext(v2);
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
    }
}

