/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.parallel.ParallelReduce$ParallelReduceSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.parallel.ParallelFlowable;
import java.util.concurrent.Callable;

public final class ParallelReduce<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<? extends T> source;
    final Callable<R> initialSupplier;
    final BiFunction<R, ? super T, R> reducer;

    public ParallelReduce(ParallelFlowable<? extends T> source, Callable<R> initialSupplier, BiFunction<R, ? super T, R> reducer) {
        this.source = source;
        this.initialSupplier = initialSupplier;
        this.reducer = reducer;
    }

    @Override
    public void subscribe(Yx<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n2 = subscribers.length;
        Yx[] parents = new Yx[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            R initialValue;
            try {
                initialValue = ObjectHelper.requireNonNull(this.initialSupplier.call(), "The initialSupplier returned a null value");
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.reportError(subscribers, ex2);
                return;
            }
            parents[i2] = new ParallelReduce$ParallelReduceSubscriber<T, R>(subscribers[i2], initialValue, this.reducer);
        }
        this.source.subscribe(parents);
    }

    void reportError(Yx<?>[] subscribers, Throwable ex2) {
        for (Yx<?> s2 : subscribers) {
            EmptySubscription.error(ex2, s2);
        }
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }
}

