/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.parallel.ParallelReduceFull$ParallelReduceFullMainSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

final class ParallelReduceFull$ParallelReduceFullInnerSubscriber<T>
extends AtomicReference<Yy>
implements FlowableSubscriber<T> {
    private static final long serialVersionUID = -7954444275102466525L;
    final ParallelReduceFull$ParallelReduceFullMainSubscriber<T> parent;
    final BiFunction<T, T, T> reducer;
    T value;
    boolean done;

    ParallelReduceFull$ParallelReduceFullInnerSubscriber(ParallelReduceFull$ParallelReduceFullMainSubscriber<T> parent, BiFunction<T, T, T> reducer) {
        this.parent = parent;
        this.reducer = reducer;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.setOnce(this, s2)) {
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        if (!this.done) {
            T v2 = this.value;
            if (v2 == null) {
                this.value = t2;
            } else {
                try {
                    v2 = ObjectHelper.requireNonNull(this.reducer.apply(v2, t2), "The reducer returned a null value");
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    ((Yy)this.get()).cancel();
                    this.onError(ex2);
                    return;
                }
                this.value = v2;
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.parent.innerError(t2);
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            this.parent.innerComplete(this.value);
        }
    }

    void cancel() {
        SubscriptionHelper.cancel(this);
    }
}

