/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler$Worker;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

abstract class ParallelRunOn$BaseRunOnSubscriber<T>
extends AtomicInteger
implements Yy,
FlowableSubscriber<T>,
Runnable {
    private static final long serialVersionUID = 9222303586456402150L;
    final int prefetch;
    final int limit;
    final SpscArrayQueue<T> queue;
    final Scheduler$Worker worker;
    Yy s;
    volatile boolean done;
    Throwable error;
    final AtomicLong requested = new AtomicLong();
    volatile boolean cancelled;
    int consumed;

    ParallelRunOn$BaseRunOnSubscriber(int prefetch, SpscArrayQueue<T> queue, Scheduler$Worker worker) {
        this.prefetch = prefetch;
        this.queue = queue;
        this.limit = prefetch - (prefetch >> 2);
        this.worker = worker;
    }

    @Override
    public final void onNext(T t2) {
        if (this.done) {
            return;
        }
        if (!this.queue.offer(t2)) {
            this.s.cancel();
            this.onError(new MissingBackpressureException("Queue is full?!"));
            return;
        }
        this.schedule();
    }

    @Override
    public final void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.error = t2;
        this.done = true;
        this.schedule();
    }

    @Override
    public final void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.schedule();
    }

    @Override
    public final void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.schedule();
        }
    }

    @Override
    public final void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.s.cancel();
            this.worker.dispose();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }
    }

    final void schedule() {
        if (this.getAndIncrement() == 0) {
            this.worker.schedule(this);
        }
    }
}

