/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.operators.parallel.ParallelSortedJoin$SortedJoinInnerSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class ParallelSortedJoin$SortedJoinSubscription<T>
extends AtomicInteger
implements Yy {
    private static final long serialVersionUID = 3481980673745556697L;
    final Yx<? super T> actual;
    final ParallelSortedJoin$SortedJoinInnerSubscriber<T>[] subscribers;
    final List<T>[] lists;
    final int[] indexes;
    final Comparator<? super T> comparator;
    final AtomicLong requested = new AtomicLong();
    volatile boolean cancelled;
    final AtomicInteger remaining = new AtomicInteger();
    final AtomicReference<Throwable> error = new AtomicReference();

    ParallelSortedJoin$SortedJoinSubscription(Yx<? super T> actual, int n2, Comparator<? super T> comparator) {
        this.actual = actual;
        this.comparator = comparator;
        ParallelSortedJoin$SortedJoinInnerSubscriber[] s2 = new ParallelSortedJoin$SortedJoinInnerSubscriber[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            s2[i2] = new ParallelSortedJoin$SortedJoinInnerSubscriber(this, i2);
        }
        this.subscribers = s2;
        this.lists = new List[n2];
        this.indexes = new int[n2];
        this.remaining.lazySet(n2);
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            if (this.remaining.get() == 0) {
                this.drain();
            }
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.cancelAll();
            if (this.getAndIncrement() == 0) {
                Arrays.fill(this.lists, null);
            }
        }
    }

    void cancelAll() {
        for (ParallelSortedJoin$SortedJoinInnerSubscriber<T> s2 : this.subscribers) {
            s2.cancel();
        }
    }

    void innerNext(List<T> value, int index) {
        this.lists[index] = value;
        if (this.remaining.decrementAndGet() == 0) {
            this.drain();
        }
    }

    void innerError(Throwable e2) {
        if (this.error.compareAndSet(null, e2)) {
            this.drain();
        } else if (e2 != this.error.get()) {
            RxJavaPlugins.onError(e2);
        }
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Yx<T> a2 = this.actual;
        Object[] lists = this.lists;
        int[] indexes = this.indexes;
        int n2 = indexes.length;
        while (true) {
            int w2;
            Throwable ex2;
            long e2;
            long r2 = this.requested.get();
            for (e2 = 0L; e2 != r2; ++e2) {
                if (this.cancelled) {
                    Arrays.fill(lists, null);
                    return;
                }
                ex2 = this.error.get();
                if (ex2 != null) {
                    this.cancelAll();
                    Arrays.fill(lists, null);
                    a2.onError(ex2);
                    return;
                }
                Object min = null;
                int minIndex = -1;
                for (int i2 = 0; i2 < n2; ++i2) {
                    boolean smaller;
                    Object list = lists[i2];
                    int index = indexes[i2];
                    if (list.size() == index) continue;
                    if (min == null) {
                        min = list.get(index);
                        minIndex = i2;
                        continue;
                    }
                    Object b2 = list.get(index);
                    try {
                        smaller = this.comparator.compare(min, b2) > 0;
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal(exc);
                        this.cancelAll();
                        Arrays.fill(lists, null);
                        if (!this.error.compareAndSet(null, exc)) {
                            RxJavaPlugins.onError(exc);
                        }
                        a2.onError(this.error.get());
                        return;
                    }
                    if (!smaller) continue;
                    min = b2;
                    minIndex = i2;
                }
                if (min == null) {
                    Arrays.fill(lists, null);
                    a2.onComplete();
                    return;
                }
                a2.onNext(min);
                int n3 = minIndex;
                indexes[n3] = indexes[n3] + 1;
            }
            if (e2 == r2) {
                if (this.cancelled) {
                    Arrays.fill(lists, null);
                    return;
                }
                ex2 = this.error.get();
                if (ex2 != null) {
                    this.cancelAll();
                    Arrays.fill(lists, null);
                    a2.onError(ex2);
                    return;
                }
                boolean empty = true;
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (indexes[i3] == lists[i3].size()) continue;
                    empty = false;
                    break;
                }
                if (empty) {
                    Arrays.fill(lists, null);
                    a2.onComplete();
                    return;
                }
            }
            if (e2 != 0L && r2 != Long.MAX_VALUE) {
                this.requested.addAndGet(-e2);
            }
            if ((w2 = this.get()) == missed) {
                if ((missed = this.addAndGet(-missed)) != 0) continue;
                break;
            }
            missed = w2;
        }
    }
}

