/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.SingleEmitter;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Cancellable;
import io.reactivex.internal.disposables.CancellableDisposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

final class SingleCreate$Emitter<T>
extends AtomicReference<Disposable>
implements SingleEmitter<T>,
Disposable {
    final SingleObserver<? super T> actual;
    private static final long serialVersionUID = -2467358622224974244L;

    SingleCreate$Emitter(SingleObserver<? super T> actual) {
        this.actual = actual;
    }

    @Override
    public void onSuccess(T value) {
        Disposable d2;
        if (this.get() != DisposableHelper.DISPOSED && (d2 = (Disposable)this.getAndSet(DisposableHelper.DISPOSED)) != DisposableHelper.DISPOSED) {
            try {
                if (value == null) {
                    this.actual.onError(new NullPointerException("onSuccess called with null. Null values are generally not allowed in 2.x operators and sources."));
                } else {
                    this.actual.onSuccess(value);
                }
            }
            finally {
                if (d2 != null) {
                    d2.dispose();
                }
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (!this.tryOnError(t2)) {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public boolean tryOnError(Throwable t2) {
        Disposable d2;
        if (t2 == null) {
            t2 = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        }
        if (this.get() != DisposableHelper.DISPOSED && (d2 = (Disposable)this.getAndSet(DisposableHelper.DISPOSED)) != DisposableHelper.DISPOSED) {
            try {
                this.actual.onError(t2);
            }
            finally {
                if (d2 != null) {
                    d2.dispose();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void setDisposable(Disposable d2) {
        DisposableHelper.set(this, d2);
    }

    @Override
    public void setCancellable(Cancellable c2) {
        this.setDisposable(new CancellableDisposable(c2));
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }
}

