/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;

final class SingleDoFinally$DoFinallyObserver<T>
extends AtomicInteger
implements SingleObserver<T>,
Disposable {
    private static final long serialVersionUID = 4109457741734051389L;
    final SingleObserver<? super T> actual;
    final Action onFinally;
    Disposable d;

    SingleDoFinally$DoFinallyObserver(SingleObserver<? super T> actual, Action onFinally) {
        this.actual = actual;
        this.onFinally = onFinally;
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T t2) {
        this.actual.onSuccess(t2);
        this.runFinally();
    }

    @Override
    public void onError(Throwable t2) {
        this.actual.onError(t2);
        this.runFinally();
    }

    @Override
    public void dispose() {
        this.d.dispose();
        this.runFinally();
    }

    @Override
    public boolean isDisposed() {
        return this.d.isDisposed();
    }

    void runFinally() {
        if (this.compareAndSet(0, 1)) {
            try {
                this.onFinally.run();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                RxJavaPlugins.onError(ex2);
            }
        }
    }
}

