/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.atomic.AtomicReference;

final class SingleFlatMapCompletable$FlatMapCompletableObserver<T>
extends AtomicReference<Disposable>
implements CompletableObserver,
SingleObserver<T>,
Disposable {
    private static final long serialVersionUID = -2177128922851101253L;
    final CompletableObserver actual;
    final Function<? super T, ? extends CompletableSource> mapper;

    SingleFlatMapCompletable$FlatMapCompletableObserver(CompletableObserver actual, Function<? super T, ? extends CompletableSource> mapper) {
        this.actual = actual;
        this.mapper = mapper;
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }

    @Override
    public void onSubscribe(Disposable d2) {
        DisposableHelper.replace(this, d2);
    }

    @Override
    public void onSuccess(T value) {
        CompletableSource cs2;
        try {
            cs2 = ObjectHelper.requireNonNull(this.mapper.apply(value), "The mapper returned a null CompletableSource");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.onError(ex2);
            return;
        }
        if (!this.isDisposed()) {
            cs2.subscribe(this);
        }
    }

    @Override
    public void onError(Throwable e2) {
        this.actual.onError(e2);
    }

    @Override
    public void onComplete() {
        this.actual.onComplete();
    }
}

