/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Scheduler;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import java.util.concurrent.atomic.AtomicReference;

final class SingleObserveOn$ObserveOnSingleObserver<T>
extends AtomicReference<Disposable>
implements SingleObserver<T>,
Disposable,
Runnable {
    private static final long serialVersionUID = 3528003840217436037L;
    final SingleObserver<? super T> actual;
    final Scheduler scheduler;
    T value;
    Throwable error;

    SingleObserveOn$ObserveOnSingleObserver(SingleObserver<? super T> actual, Scheduler scheduler) {
        this.actual = actual;
        this.scheduler = scheduler;
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.setOnce(this, d2)) {
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        this.value = value;
        Disposable d2 = this.scheduler.scheduleDirect(this);
        DisposableHelper.replace(this, d2);
    }

    @Override
    public void onError(Throwable e2) {
        this.error = e2;
        Disposable d2 = this.scheduler.scheduleDirect(this);
        DisposableHelper.replace(this, d2);
    }

    @Override
    public void run() {
        Throwable ex2 = this.error;
        if (ex2 != null) {
            this.actual.onError(ex2);
        } else {
            this.actual.onSuccess(this.value);
        }
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }
}

