/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.single.SingleTimeout$TimeoutMainObserver$TimeoutFallbackObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

final class SingleTimeout$TimeoutMainObserver<T>
extends AtomicReference<Disposable>
implements SingleObserver<T>,
Disposable,
Runnable {
    private static final long serialVersionUID = 37497744973048446L;
    final SingleObserver<? super T> actual;
    final AtomicReference<Disposable> task;
    final SingleTimeout$TimeoutMainObserver$TimeoutFallbackObserver<T> fallback;
    SingleSource<? extends T> other;

    SingleTimeout$TimeoutMainObserver(SingleObserver<? super T> actual, SingleSource<? extends T> other) {
        this.actual = actual;
        this.other = other;
        this.task = new AtomicReference();
        this.fallback = other != null ? new SingleTimeout$TimeoutMainObserver$TimeoutFallbackObserver<T>(actual) : null;
    }

    @Override
    public void run() {
        Disposable d2 = (Disposable)this.get();
        if (d2 != DisposableHelper.DISPOSED && this.compareAndSet(d2, DisposableHelper.DISPOSED)) {
            SingleSource<T> other;
            if (d2 != null) {
                d2.dispose();
            }
            if ((other = this.other) == null) {
                this.actual.onError(new TimeoutException());
            } else {
                this.other = null;
                other.subscribe(this.fallback);
            }
        }
    }

    @Override
    public void onSubscribe(Disposable d2) {
        DisposableHelper.setOnce(this, d2);
    }

    @Override
    public void onSuccess(T t2) {
        Disposable d2 = (Disposable)this.get();
        if (d2 != DisposableHelper.DISPOSED && this.compareAndSet(d2, DisposableHelper.DISPOSED)) {
            DisposableHelper.dispose(this.task);
            this.actual.onSuccess(t2);
        }
    }

    @Override
    public void onError(Throwable e2) {
        Disposable d2 = (Disposable)this.get();
        if (d2 != DisposableHelper.DISPOSED && this.compareAndSet(d2, DisposableHelper.DISPOSED)) {
            DisposableHelper.dispose(this.task);
            this.actual.onError(e2);
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
        DisposableHelper.dispose(this.task);
        if (this.fallback != null) {
            DisposableHelper.dispose(this.fallback);
        }
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }
}

