/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

final class SingleUsing$UsingSingleObserver<T, U>
extends AtomicReference<Object>
implements SingleObserver<T>,
Disposable {
    private static final long serialVersionUID = -5331524057054083935L;
    final SingleObserver<? super T> actual;
    final Consumer<? super U> disposer;
    final boolean eager;
    Disposable d;

    SingleUsing$UsingSingleObserver(SingleObserver<? super T> actual, U resource, boolean eager, Consumer<? super U> disposer) {
        super(resource);
        this.actual = actual;
        this.eager = eager;
        this.disposer = disposer;
    }

    @Override
    public void dispose() {
        this.d.dispose();
        this.d = DisposableHelper.DISPOSED;
        this.disposeAfter();
    }

    @Override
    public boolean isDisposed() {
        return this.d.isDisposed();
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        this.d = DisposableHelper.DISPOSED;
        if (this.eager) {
            SingleUsing$UsingSingleObserver u2 = this.getAndSet(this);
            if (u2 != this) {
                try {
                    this.disposer.accept(u2);
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    this.actual.onError(ex2);
                    return;
                }
            } else {
                return;
            }
        }
        this.actual.onSuccess(value);
        if (!this.eager) {
            this.disposeAfter();
        }
    }

    @Override
    public void onError(Throwable e2) {
        this.d = DisposableHelper.DISPOSED;
        if (this.eager) {
            SingleUsing$UsingSingleObserver u2 = this.getAndSet(this);
            if (u2 != this) {
                try {
                    this.disposer.accept(u2);
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    e2 = new CompositeException(e2, ex2);
                }
            } else {
                return;
            }
        }
        this.actual.onError(e2);
        if (!this.eager) {
            this.disposeAfter();
        }
    }

    void disposeAfter() {
        SingleUsing$UsingSingleObserver u2 = this.getAndSet(this);
        if (u2 != this) {
            try {
                this.disposer.accept(u2);
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                RxJavaPlugins.onError(ex2);
            }
        }
    }
}

