/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.single.SingleMap$MapSingleObserver;
import io.reactivex.internal.operators.single.SingleZipArray$ZipCoordinator;
import io.reactivex.internal.operators.single.SingleZipIterable$SingletonArrayFunc;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class SingleZipIterable<T, R>
extends Single<R> {
    final Iterable<? extends SingleSource<? extends T>> sources;
    final Function<? super Object[], ? extends R> zipper;

    public SingleZipIterable(Iterable<? extends SingleSource<? extends T>> sources, Function<? super Object[], ? extends R> zipper) {
        this.sources = sources;
        this.zipper = zipper;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void subscribeActual(SingleObserver<? super R> observer) {
        void var5_8;
        SingleSource[] a2 = new SingleSource[8];
        int n2 = 0;
        try {
            for (SingleSource<? extends T> singleSource : this.sources) {
                if (singleSource == null) {
                    EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), observer);
                    return;
                }
                if (n2 == a2.length) {
                    a2 = Arrays.copyOf(a2, n2 + (n2 >> 2));
                }
                a2[n2++] = singleSource;
            }
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            EmptyDisposable.error(ex2, observer);
            return;
        }
        if (n2 == 0) {
            EmptyDisposable.error((Throwable)new NoSuchElementException(), observer);
            return;
        }
        if (n2 == 1) {
            a2[0].subscribe(new SingleMap$MapSingleObserver(observer, new SingleZipIterable$SingletonArrayFunc(this)));
            return;
        }
        SingleZipArray$ZipCoordinator parent = new SingleZipArray$ZipCoordinator(observer, n2, this.zipper);
        observer.onSubscribe(parent);
        boolean bl2 = false;
        while (var5_8 < n2) {
            if (parent.isDisposed()) {
                return;
            }
            a2[var5_8].subscribe(parent.observers[var5_8]);
            ++var5_8;
        }
    }
}

