/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.queue;

import io.reactivex.annotations.Nullable;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.MpscLinkedQueue$LinkedQueueNode;
import java.util.concurrent.atomic.AtomicReference;

public final class MpscLinkedQueue<T>
implements SimplePlainQueue<T> {
    private final AtomicReference<MpscLinkedQueue$LinkedQueueNode<T>> producerNode = new AtomicReference();
    private final AtomicReference<MpscLinkedQueue$LinkedQueueNode<T>> consumerNode = new AtomicReference();

    public MpscLinkedQueue() {
        MpscLinkedQueue$LinkedQueueNode node = new MpscLinkedQueue$LinkedQueueNode();
        this.spConsumerNode(node);
        this.xchgProducerNode(node);
    }

    @Override
    public boolean offer(T e2) {
        if (null == e2) {
            throw new NullPointerException("Null is not a valid element");
        }
        MpscLinkedQueue$LinkedQueueNode<T> nextNode = new MpscLinkedQueue$LinkedQueueNode<T>(e2);
        MpscLinkedQueue$LinkedQueueNode<T> prevProducerNode = this.xchgProducerNode(nextNode);
        prevProducerNode.soNext(nextNode);
        return true;
    }

    @Override
    @Nullable
    public T poll() {
        MpscLinkedQueue$LinkedQueueNode<T> currConsumerNode = this.lpConsumerNode();
        MpscLinkedQueue$LinkedQueueNode<T> nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            T nextValue = nextNode.getAndNullValue();
            this.spConsumerNode(nextNode);
            return nextValue;
        }
        if (currConsumerNode != this.lvProducerNode()) {
            while ((nextNode = currConsumerNode.lvNext()) == null) {
            }
            T nextValue = nextNode.getAndNullValue();
            this.spConsumerNode(nextNode);
            return nextValue;
        }
        return null;
    }

    @Override
    public boolean offer(T v1, T v2) {
        this.offer(v1);
        this.offer(v2);
        return true;
    }

    @Override
    public void clear() {
        while (this.poll() != null && !this.isEmpty()) {
        }
    }

    MpscLinkedQueue$LinkedQueueNode<T> lvProducerNode() {
        return this.producerNode.get();
    }

    MpscLinkedQueue$LinkedQueueNode<T> xchgProducerNode(MpscLinkedQueue$LinkedQueueNode<T> node) {
        return this.producerNode.getAndSet(node);
    }

    MpscLinkedQueue$LinkedQueueNode<T> lvConsumerNode() {
        return this.consumerNode.get();
    }

    MpscLinkedQueue$LinkedQueueNode<T> lpConsumerNode() {
        return this.consumerNode.get();
    }

    void spConsumerNode(MpscLinkedQueue$LinkedQueueNode<T> node) {
        this.consumerNode.lazySet(node);
    }

    @Override
    public boolean isEmpty() {
        return this.lvConsumerNode() == this.lvProducerNode();
    }
}

