/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Scheduler$Worker;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.disposables.ListCompositeDisposable;
import io.reactivex.internal.schedulers.ComputationScheduler$PoolWorker;
import java.util.concurrent.TimeUnit;

final class ComputationScheduler$EventLoopWorker
extends Scheduler$Worker {
    private final ListCompositeDisposable serial;
    private final CompositeDisposable timed;
    private final ListCompositeDisposable both;
    private final ComputationScheduler$PoolWorker poolWorker;
    volatile boolean disposed;

    ComputationScheduler$EventLoopWorker(ComputationScheduler$PoolWorker poolWorker) {
        this.poolWorker = poolWorker;
        this.serial = new ListCompositeDisposable();
        this.timed = new CompositeDisposable();
        this.both = new ListCompositeDisposable();
        this.both.add(this.serial);
        this.both.add(this.timed);
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.both.dispose();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable action) {
        if (this.disposed) {
            return EmptyDisposable.INSTANCE;
        }
        return this.poolWorker.scheduleActual(action, 0L, TimeUnit.MILLISECONDS, this.serial);
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable action, long delayTime, @NonNull TimeUnit unit) {
        if (this.disposed) {
            return EmptyDisposable.INSTANCE;
        }
        return this.poolWorker.scheduleActual(action, delayTime, unit, this.timed);
    }
}

