/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.internal.schedulers.ComputationScheduler;
import io.reactivex.internal.schedulers.ComputationScheduler$EventLoopWorker;
import io.reactivex.internal.schedulers.ComputationScheduler$PoolWorker;
import io.reactivex.internal.schedulers.SchedulerMultiWorkerSupport;
import io.reactivex.internal.schedulers.SchedulerMultiWorkerSupport$WorkerCallback;
import java.util.concurrent.ThreadFactory;

final class ComputationScheduler$FixedSchedulerPool
implements SchedulerMultiWorkerSupport {
    final int cores;
    final ComputationScheduler$PoolWorker[] eventLoops;
    long n;

    ComputationScheduler$FixedSchedulerPool(int maxThreads, ThreadFactory threadFactory) {
        this.cores = maxThreads;
        this.eventLoops = new ComputationScheduler$PoolWorker[maxThreads];
        for (int i2 = 0; i2 < maxThreads; ++i2) {
            this.eventLoops[i2] = new ComputationScheduler$PoolWorker(threadFactory);
        }
    }

    public ComputationScheduler$PoolWorker getEventLoop() {
        int c2 = this.cores;
        if (c2 == 0) {
            return ComputationScheduler.SHUTDOWN_WORKER;
        }
        return this.eventLoops[(int)(this.n++ % (long)c2)];
    }

    public void shutdown() {
        for (ComputationScheduler$PoolWorker w2 : this.eventLoops) {
            w2.dispose();
        }
    }

    @Override
    public void createWorkers(int number, SchedulerMultiWorkerSupport$WorkerCallback callback) {
        int c2 = this.cores;
        if (c2 == 0) {
            for (int i2 = 0; i2 < number; ++i2) {
                callback.onWorker(i2, ComputationScheduler.SHUTDOWN_WORKER);
            }
        } else {
            int index = (int)this.n % c2;
            for (int i3 = 0; i3 < number; ++i3) {
                callback.onWorker(i3, new ComputationScheduler$EventLoopWorker(this.eventLoops[index]));
                if (++index != c2) continue;
                index = 0;
            }
            this.n = index;
        }
    }
}

