/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Scheduler;
import io.reactivex.Scheduler$Worker;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.schedulers.ComputationScheduler$EventLoopWorker;
import io.reactivex.internal.schedulers.ComputationScheduler$FixedSchedulerPool;
import io.reactivex.internal.schedulers.ComputationScheduler$PoolWorker;
import io.reactivex.internal.schedulers.RxThreadFactory;
import io.reactivex.internal.schedulers.SchedulerMultiWorkerSupport;
import io.reactivex.internal.schedulers.SchedulerMultiWorkerSupport$WorkerCallback;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ComputationScheduler
extends Scheduler
implements SchedulerMultiWorkerSupport {
    static final ComputationScheduler$FixedSchedulerPool NONE;
    private static final String THREAD_NAME_PREFIX = "RxComputationThreadPool";
    static final RxThreadFactory THREAD_FACTORY;
    static final String KEY_MAX_THREADS = "rx2.computation-threads";
    static final int MAX_THREADS;
    static final ComputationScheduler$PoolWorker SHUTDOWN_WORKER;
    final ThreadFactory threadFactory;
    final AtomicReference<ComputationScheduler$FixedSchedulerPool> pool;
    private static final String KEY_COMPUTATION_PRIORITY = "rx2.computation-priority";

    static int cap(int cpuCount, int paramThreads) {
        return paramThreads <= 0 || paramThreads > cpuCount ? cpuCount : paramThreads;
    }

    public ComputationScheduler() {
        this(THREAD_FACTORY);
    }

    public ComputationScheduler(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        this.pool = new AtomicReference<ComputationScheduler$FixedSchedulerPool>(NONE);
        this.start();
    }

    @Override
    @NonNull
    public Scheduler$Worker createWorker() {
        return new ComputationScheduler$EventLoopWorker(this.pool.get().getEventLoop());
    }

    @Override
    public void createWorkers(int number, SchedulerMultiWorkerSupport$WorkerCallback callback) {
        ObjectHelper.verifyPositive(number, "number > 0 required");
        this.pool.get().createWorkers(number, callback);
    }

    @Override
    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run, long delay, TimeUnit unit) {
        ComputationScheduler$PoolWorker w2 = this.pool.get().getEventLoop();
        return w2.scheduleDirect(run, delay, unit);
    }

    @Override
    @NonNull
    public Disposable schedulePeriodicallyDirect(@NonNull Runnable run, long initialDelay, long period, TimeUnit unit) {
        ComputationScheduler$PoolWorker w2 = this.pool.get().getEventLoop();
        return w2.schedulePeriodicallyDirect(run, initialDelay, period, unit);
    }

    @Override
    public void start() {
        ComputationScheduler$FixedSchedulerPool update = new ComputationScheduler$FixedSchedulerPool(MAX_THREADS, this.threadFactory);
        if (!this.pool.compareAndSet(NONE, update)) {
            update.shutdown();
        }
    }

    @Override
    public void shutdown() {
        ComputationScheduler$FixedSchedulerPool curr;
        do {
            if ((curr = this.pool.get()) != NONE) continue;
            return;
        } while (!this.pool.compareAndSet(curr, NONE));
        curr.shutdown();
    }

    static {
        MAX_THREADS = ComputationScheduler.cap(Runtime.getRuntime().availableProcessors(), Integer.getInteger(KEY_MAX_THREADS, 0));
        SHUTDOWN_WORKER = new ComputationScheduler$PoolWorker(new RxThreadFactory("RxComputationShutdown"));
        SHUTDOWN_WORKER.dispose();
        int priority = Math.max(1, Math.min(10, Integer.getInteger(KEY_COMPUTATION_PRIORITY, 5)));
        THREAD_FACTORY = new RxThreadFactory(THREAD_NAME_PREFIX, priority, true);
        NONE = new ComputationScheduler$FixedSchedulerPool(0, THREAD_FACTORY);
        NONE.shutdown();
    }
}

