/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.functions.Functions;
import io.reactivex.schedulers.SchedulerRunnableIntrospection;
import java.util.concurrent.atomic.AtomicReference;

final class ExecutorScheduler$DelayedRunnable
extends AtomicReference<Runnable>
implements Disposable,
SchedulerRunnableIntrospection,
Runnable {
    private static final long serialVersionUID = -4101336210206799084L;
    final SequentialDisposable timed = new SequentialDisposable();
    final SequentialDisposable direct = new SequentialDisposable();

    ExecutorScheduler$DelayedRunnable(Runnable run) {
        super(run);
    }

    @Override
    public void run() {
        Runnable r2 = (Runnable)this.get();
        if (r2 != null) {
            try {
                r2.run();
            }
            finally {
                this.lazySet(null);
                this.timed.lazySet(DisposableHelper.DISPOSED);
                this.direct.lazySet(DisposableHelper.DISPOSED);
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.get() == null;
    }

    @Override
    public void dispose() {
        if (this.getAndSet(null) != null) {
            this.timed.dispose();
            this.direct.dispose();
        }
    }

    @Override
    public Runnable getWrappedRunnable() {
        Runnable r2 = (Runnable)this.get();
        return r2 != null ? r2 : Functions.EMPTY_RUNNABLE;
    }
}

