/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Scheduler;
import io.reactivex.Scheduler$Worker;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.schedulers.ExecutorScheduler$DelayedDispose;
import io.reactivex.internal.schedulers.ExecutorScheduler$DelayedRunnable;
import io.reactivex.internal.schedulers.ExecutorScheduler$ExecutorWorker;
import io.reactivex.internal.schedulers.ExecutorScheduler$ExecutorWorker$BooleanRunnable;
import io.reactivex.internal.schedulers.ScheduledDirectPeriodicTask;
import io.reactivex.internal.schedulers.ScheduledDirectTask;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class ExecutorScheduler
extends Scheduler {
    @NonNull
    final Executor executor;
    static final Scheduler HELPER = Schedulers.single();

    public ExecutorScheduler(@NonNull Executor executor) {
        this.executor = executor;
    }

    @Override
    @NonNull
    public Scheduler$Worker createWorker() {
        return new ExecutorScheduler$ExecutorWorker(this.executor);
    }

    @Override
    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        try {
            if (this.executor instanceof ExecutorService) {
                ScheduledDirectTask task = new ScheduledDirectTask(decoratedRun);
                Future<Void> f2 = ((ExecutorService)this.executor).submit(task);
                task.setFuture(f2);
                return task;
            }
            ExecutorScheduler$ExecutorWorker$BooleanRunnable br2 = new ExecutorScheduler$ExecutorWorker$BooleanRunnable(decoratedRun);
            this.executor.execute(br2);
            return br2;
        }
        catch (RejectedExecutionException ex2) {
            RxJavaPlugins.onError(ex2);
            return EmptyDisposable.INSTANCE;
        }
    }

    @Override
    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run, long delay, TimeUnit unit) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        if (this.executor instanceof ScheduledExecutorService) {
            try {
                ScheduledDirectTask task = new ScheduledDirectTask(decoratedRun);
                ScheduledFuture<Void> f2 = ((ScheduledExecutorService)this.executor).schedule(task, delay, unit);
                task.setFuture(f2);
                return task;
            }
            catch (RejectedExecutionException ex2) {
                RxJavaPlugins.onError(ex2);
                return EmptyDisposable.INSTANCE;
            }
        }
        ExecutorScheduler$DelayedRunnable dr2 = new ExecutorScheduler$DelayedRunnable(decoratedRun);
        Disposable delayed = HELPER.scheduleDirect(new ExecutorScheduler$DelayedDispose(this, dr2), delay, unit);
        dr2.timed.replace(delayed);
        return dr2;
    }

    @Override
    @NonNull
    public Disposable schedulePeriodicallyDirect(@NonNull Runnable run, long initialDelay, long period, TimeUnit unit) {
        if (this.executor instanceof ScheduledExecutorService) {
            Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
            try {
                ScheduledDirectPeriodicTask task = new ScheduledDirectPeriodicTask(decoratedRun);
                ScheduledFuture<?> f2 = ((ScheduledExecutorService)this.executor).scheduleAtFixedRate(task, initialDelay, period, unit);
                task.setFuture(f2);
                return task;
            }
            catch (RejectedExecutionException ex2) {
                RxJavaPlugins.onError(ex2);
                return EmptyDisposable.INSTANCE;
            }
        }
        return super.schedulePeriodicallyDirect(run, initialDelay, period, unit);
    }
}

