/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.internal.schedulers.IoScheduler;
import io.reactivex.internal.schedulers.IoScheduler$ThreadWorker;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

final class IoScheduler$CachedWorkerPool
implements Runnable {
    private final long keepAliveTime;
    private final ConcurrentLinkedQueue<IoScheduler$ThreadWorker> expiringWorkerQueue;
    final CompositeDisposable allWorkers;
    private final ScheduledExecutorService evictorService;
    private final Future<?> evictorTask;
    private final ThreadFactory threadFactory;

    IoScheduler$CachedWorkerPool(long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        this.keepAliveTime = unit != null ? unit.toNanos(keepAliveTime) : 0L;
        this.expiringWorkerQueue = new ConcurrentLinkedQueue();
        this.allWorkers = new CompositeDisposable();
        this.threadFactory = threadFactory;
        ScheduledExecutorService evictor = null;
        ScheduledFuture<?> task = null;
        if (unit != null) {
            evictor = Executors.newScheduledThreadPool(1, IoScheduler.EVICTOR_THREAD_FACTORY);
            task = evictor.scheduleWithFixedDelay(this, this.keepAliveTime, this.keepAliveTime, TimeUnit.NANOSECONDS);
        }
        this.evictorService = evictor;
        this.evictorTask = task;
    }

    @Override
    public void run() {
        this.evictExpiredWorkers();
    }

    IoScheduler$ThreadWorker get() {
        if (this.allWorkers.isDisposed()) {
            return IoScheduler.SHUTDOWN_THREAD_WORKER;
        }
        while (!this.expiringWorkerQueue.isEmpty()) {
            IoScheduler$ThreadWorker threadWorker = this.expiringWorkerQueue.poll();
            if (threadWorker == null) continue;
            return threadWorker;
        }
        IoScheduler$ThreadWorker w2 = new IoScheduler$ThreadWorker(this.threadFactory);
        this.allWorkers.add(w2);
        return w2;
    }

    void release(IoScheduler$ThreadWorker threadWorker) {
        threadWorker.setExpirationTime(this.now() + this.keepAliveTime);
        this.expiringWorkerQueue.offer(threadWorker);
    }

    void evictExpiredWorkers() {
        if (!this.expiringWorkerQueue.isEmpty()) {
            long currentTimestamp = this.now();
            for (IoScheduler$ThreadWorker threadWorker : this.expiringWorkerQueue) {
                if (threadWorker.getExpirationTime() > currentTimestamp) break;
                if (!this.expiringWorkerQueue.remove(threadWorker)) continue;
                this.allWorkers.remove(threadWorker);
            }
        }
    }

    long now() {
        return System.nanoTime();
    }

    void shutdown() {
        this.allWorkers.dispose();
        if (this.evictorTask != null) {
            this.evictorTask.cancel(true);
        }
        if (this.evictorService != null) {
            this.evictorService.shutdownNow();
        }
    }
}

