/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Scheduler$Worker;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.schedulers.IoScheduler$CachedWorkerPool;
import io.reactivex.internal.schedulers.IoScheduler$ThreadWorker;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

final class IoScheduler$EventLoopWorker
extends Scheduler$Worker {
    private final CompositeDisposable tasks;
    private final IoScheduler$CachedWorkerPool pool;
    private final IoScheduler$ThreadWorker threadWorker;
    final AtomicBoolean once = new AtomicBoolean();

    IoScheduler$EventLoopWorker(IoScheduler$CachedWorkerPool pool) {
        this.pool = pool;
        this.tasks = new CompositeDisposable();
        this.threadWorker = pool.get();
    }

    @Override
    public void dispose() {
        if (this.once.compareAndSet(false, true)) {
            this.tasks.dispose();
            this.pool.release(this.threadWorker);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.once.get();
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable action, long delayTime, @NonNull TimeUnit unit) {
        if (this.tasks.isDisposed()) {
            return EmptyDisposable.INSTANCE;
        }
        return this.threadWorker.scheduleActual(action, delayTime, unit, this.tasks);
    }
}

