/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Scheduler;
import io.reactivex.Scheduler$Worker;
import io.reactivex.annotations.NonNull;
import io.reactivex.internal.schedulers.IoScheduler$CachedWorkerPool;
import io.reactivex.internal.schedulers.IoScheduler$EventLoopWorker;
import io.reactivex.internal.schedulers.IoScheduler$ThreadWorker;
import io.reactivex.internal.schedulers.RxThreadFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class IoScheduler
extends Scheduler {
    private static final String WORKER_THREAD_NAME_PREFIX = "RxCachedThreadScheduler";
    static final RxThreadFactory WORKER_THREAD_FACTORY;
    private static final String EVICTOR_THREAD_NAME_PREFIX = "RxCachedWorkerPoolEvictor";
    static final RxThreadFactory EVICTOR_THREAD_FACTORY;
    private static final long KEEP_ALIVE_TIME = 60L;
    private static final TimeUnit KEEP_ALIVE_UNIT;
    static final IoScheduler$ThreadWorker SHUTDOWN_THREAD_WORKER;
    final ThreadFactory threadFactory;
    final AtomicReference<IoScheduler$CachedWorkerPool> pool;
    private static final String KEY_IO_PRIORITY = "rx2.io-priority";
    static final IoScheduler$CachedWorkerPool NONE;

    public IoScheduler() {
        this(WORKER_THREAD_FACTORY);
    }

    public IoScheduler(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        this.pool = new AtomicReference<IoScheduler$CachedWorkerPool>(NONE);
        this.start();
    }

    @Override
    public void start() {
        IoScheduler$CachedWorkerPool update = new IoScheduler$CachedWorkerPool(60L, KEEP_ALIVE_UNIT, this.threadFactory);
        if (!this.pool.compareAndSet(NONE, update)) {
            update.shutdown();
        }
    }

    @Override
    public void shutdown() {
        IoScheduler$CachedWorkerPool curr;
        do {
            if ((curr = this.pool.get()) != NONE) continue;
            return;
        } while (!this.pool.compareAndSet(curr, NONE));
        curr.shutdown();
    }

    @Override
    @NonNull
    public Scheduler$Worker createWorker() {
        return new IoScheduler$EventLoopWorker(this.pool.get());
    }

    public int size() {
        return this.pool.get().allWorkers.size();
    }

    static {
        KEEP_ALIVE_UNIT = TimeUnit.SECONDS;
        SHUTDOWN_THREAD_WORKER = new IoScheduler$ThreadWorker(new RxThreadFactory("RxCachedThreadSchedulerShutdown"));
        SHUTDOWN_THREAD_WORKER.dispose();
        int priority = Math.max(1, Math.min(10, Integer.getInteger(KEY_IO_PRIORITY, 5)));
        WORKER_THREAD_FACTORY = new RxThreadFactory(WORKER_THREAD_NAME_PREFIX, priority);
        EVICTOR_THREAD_FACTORY = new RxThreadFactory(EVICTOR_THREAD_NAME_PREFIX, priority);
        NONE = new IoScheduler$CachedWorkerPool(0L, null, WORKER_THREAD_FACTORY);
        NONE.shutdown();
    }
}

