/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.internal.schedulers.RxThreadFactory$RxCustomThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class RxThreadFactory
extends AtomicLong
implements ThreadFactory {
    private static final long serialVersionUID = -7789753024099756196L;
    final String prefix;
    final int priority;
    final boolean nonBlocking;

    public RxThreadFactory(String prefix) {
        this(prefix, 5, false);
    }

    public RxThreadFactory(String prefix, int priority) {
        this(prefix, priority, false);
    }

    public RxThreadFactory(String prefix, int priority, boolean nonBlocking) {
        this.prefix = prefix;
        this.priority = priority;
        this.nonBlocking = nonBlocking;
    }

    @Override
    public Thread newThread(Runnable r2) {
        StringBuilder nameBuilder = new StringBuilder(this.prefix).append('-').append(this.incrementAndGet());
        String name = nameBuilder.toString();
        Thread t2 = this.nonBlocking ? new RxThreadFactory$RxCustomThread(r2, name) : new Thread(r2, name);
        t2.setPriority(this.priority);
        t2.setDaemon(true);
        return t2;
    }

    @Override
    public String toString() {
        return "RxThreadFactory[" + this.prefix + "]";
    }
}

