/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Scheduler$Worker;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.schedulers.SchedulerWhen$DelayedAction;
import io.reactivex.internal.schedulers.SchedulerWhen$ImmediateAction;
import io.reactivex.internal.schedulers.SchedulerWhen$ScheduledAction;
import io.reactivex.processors.FlowableProcessor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

final class SchedulerWhen$QueueWorker
extends Scheduler$Worker {
    private final AtomicBoolean unsubscribed;
    private final FlowableProcessor<SchedulerWhen$ScheduledAction> actionProcessor;
    private final Scheduler$Worker actualWorker;

    SchedulerWhen$QueueWorker(FlowableProcessor<SchedulerWhen$ScheduledAction> actionProcessor, Scheduler$Worker actualWorker) {
        this.actionProcessor = actionProcessor;
        this.actualWorker = actualWorker;
        this.unsubscribed = new AtomicBoolean();
    }

    @Override
    public void dispose() {
        if (this.unsubscribed.compareAndSet(false, true)) {
            this.actionProcessor.onComplete();
            this.actualWorker.dispose();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.unsubscribed.get();
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable action, long delayTime, @NonNull TimeUnit unit) {
        SchedulerWhen$DelayedAction delayedAction = new SchedulerWhen$DelayedAction(action, delayTime, unit);
        this.actionProcessor.onNext(delayedAction);
        return delayedAction;
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable action) {
        SchedulerWhen$ImmediateAction immediateAction = new SchedulerWhen$ImmediateAction(action);
        this.actionProcessor.onNext(immediateAction);
        return immediateAction;
    }
}

