/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.CompletableObserver;
import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.schedulers.SchedulerWhen;
import java.util.concurrent.atomic.AtomicReference;

abstract class SchedulerWhen$ScheduledAction
extends AtomicReference<Disposable>
implements Disposable {
    SchedulerWhen$ScheduledAction() {
        super(SchedulerWhen.SUBSCRIBED);
    }

    void call(Scheduler$Worker actualWorker, CompletableObserver actionCompletable) {
        Disposable oldState = (Disposable)this.get();
        if (oldState == SchedulerWhen.DISPOSED) {
            return;
        }
        if (oldState != SchedulerWhen.SUBSCRIBED) {
            return;
        }
        Disposable newState = this.callActual(actualWorker, actionCompletable);
        if (!this.compareAndSet(SchedulerWhen.SUBSCRIBED, newState)) {
            newState.dispose();
        }
    }

    protected abstract Disposable callActual(Scheduler$Worker var1, CompletableObserver var2);

    @Override
    public boolean isDisposed() {
        return ((Disposable)this.get()).isDisposed();
    }

    @Override
    public void dispose() {
        Disposable oldState;
        Disposable newState = SchedulerWhen.DISPOSED;
        do {
            if ((oldState = (Disposable)this.get()) != SchedulerWhen.DISPOSED) continue;
            return;
        } while (!this.compareAndSet(oldState, newState));
        if (oldState != SchedulerWhen.SUBSCRIBED) {
            oldState.dispose();
        }
    }
}

