/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Scheduler$Worker;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.schedulers.TrampolineScheduler$SleepingRunnable;
import io.reactivex.internal.schedulers.TrampolineScheduler$TimedRunnable;
import io.reactivex.internal.schedulers.TrampolineScheduler$TrampolineWorker$AppendToQueueTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

final class TrampolineScheduler$TrampolineWorker
extends Scheduler$Worker
implements Disposable {
    final PriorityBlockingQueue<TrampolineScheduler$TimedRunnable> queue = new PriorityBlockingQueue();
    private final AtomicInteger wip = new AtomicInteger();
    final AtomicInteger counter = new AtomicInteger();
    volatile boolean disposed;

    TrampolineScheduler$TrampolineWorker() {
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable action) {
        return this.enqueue(action, this.now(TimeUnit.MILLISECONDS));
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable action, long delayTime, @NonNull TimeUnit unit) {
        long execTime = this.now(TimeUnit.MILLISECONDS) + unit.toMillis(delayTime);
        return this.enqueue(new TrampolineScheduler$SleepingRunnable(action, this, execTime), execTime);
    }

    Disposable enqueue(Runnable action, long execTime) {
        if (this.disposed) {
            return EmptyDisposable.INSTANCE;
        }
        TrampolineScheduler$TimedRunnable timedRunnable = new TrampolineScheduler$TimedRunnable(action, execTime, this.counter.incrementAndGet());
        this.queue.add(timedRunnable);
        if (this.wip.getAndIncrement() == 0) {
            int missed = 1;
            while (true) {
                if (this.disposed) {
                    this.queue.clear();
                    return EmptyDisposable.INSTANCE;
                }
                TrampolineScheduler$TimedRunnable polled = this.queue.poll();
                if (polled != null) {
                    if (polled.disposed) continue;
                    polled.run.run();
                    continue;
                }
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            }
            return EmptyDisposable.INSTANCE;
        }
        return Disposables.fromRunnable(new TrampolineScheduler$TrampolineWorker$AppendToQueueTask(this, timedRunnable));
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }
}

