/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.subscribers.InnerQueuedSubscriberSupport;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.QueueDrainHelper;
import java.util.concurrent.atomic.AtomicReference;

public final class InnerQueuedSubscriber<T>
extends AtomicReference<Yy>
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = 22876611072430776L;
    final InnerQueuedSubscriberSupport<T> parent;
    final int prefetch;
    final int limit;
    volatile SimpleQueue<T> queue;
    volatile boolean done;
    long produced;
    int fusionMode;

    public InnerQueuedSubscriber(InnerQueuedSubscriberSupport<T> parent, int prefetch) {
        this.parent = parent;
        this.prefetch = prefetch;
        this.limit = prefetch - (prefetch >> 2);
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.setOnce(this, s2)) {
            if (s2 instanceof QueueSubscription) {
                QueueSubscription qs2 = (QueueSubscription)s2;
                int m2 = qs2.requestFusion(3);
                if (m2 == 1) {
                    this.fusionMode = m2;
                    this.queue = qs2;
                    this.done = true;
                    this.parent.innerComplete(this);
                    return;
                }
                if (m2 == 2) {
                    this.fusionMode = m2;
                    this.queue = qs2;
                    QueueDrainHelper.request(s2, this.prefetch);
                    return;
                }
            }
            this.queue = QueueDrainHelper.createQueue(this.prefetch);
            QueueDrainHelper.request(s2, this.prefetch);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.fusionMode == 0) {
            this.parent.innerNext(this, t2);
        } else {
            this.parent.drain();
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.parent.innerError(this, t2);
    }

    @Override
    public void onComplete() {
        this.parent.innerComplete(this);
    }

    @Override
    public void request(long n2) {
        if (this.fusionMode != 1) {
            long p2 = this.produced + n2;
            if (p2 >= (long)this.limit) {
                this.produced = 0L;
                ((Yy)this.get()).request(p2);
            } else {
                this.produced = p2;
            }
        }
    }

    public void requestOne() {
        if (this.fusionMode != 1) {
            long p2 = this.produced + 1L;
            if (p2 == (long)this.limit) {
                this.produced = 0L;
                ((Yy)this.get()).request(p2);
            } else {
                this.produced = p2;
            }
        }
    }

    @Override
    public void cancel() {
        SubscriptionHelper.cancel(this);
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone() {
        this.done = true;
    }

    public SimpleQueue<T> queue() {
        return this.queue;
    }
}

