/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers;

import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriberPad4;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.QueueDrain;
import io.reactivex.internal.util.QueueDrainHelper;

public abstract class QueueDrainSubscriber<T, U, V>
extends QueueDrainSubscriberPad4
implements FlowableSubscriber<T>,
QueueDrain<U, V> {
    protected final Yx<? super V> actual;
    public final SimplePlainQueue<U> queue;
    public volatile boolean cancelled;
    protected volatile boolean done;
    protected Throwable error;

    public QueueDrainSubscriber(Yx<? super V> actual, SimplePlainQueue<U> queue) {
        this.actual = actual;
        this.queue = queue;
    }

    @Override
    public final boolean cancelled() {
        return this.cancelled;
    }

    @Override
    public final boolean done() {
        return this.done;
    }

    @Override
    public final boolean enter() {
        return this.wip.getAndIncrement() == 0;
    }

    public final boolean fastEnter() {
        return this.wip.get() == 0 && this.wip.compareAndSet(0, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void fastPathEmitMax(U value, boolean delayError, Disposable dispose) {
        Yx<V> s2 = this.actual;
        SimplePlainQueue<U> q2 = this.queue;
        if (this.wip.get() == 0 && this.wip.compareAndSet(0, 1)) {
            long r2 = this.requested.get();
            if (r2 == 0L) {
                dispose.dispose();
                s2.onError(new MissingBackpressureException("Could not emit buffer due to lack of requests"));
                return;
            }
            if (this.accept((Yx<? super V>)s2, value) && r2 != Long.MAX_VALUE) {
                this.produced(1L);
            }
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            q2.offer(value);
            if (!this.enter()) {
                return;
            }
        }
        QueueDrainHelper.drainMaxLoop(q2, s2, delayError, dispose, this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void fastPathOrderedEmitMax(U value, boolean delayError, Disposable dispose) {
        Yx<V> s2 = this.actual;
        SimplePlainQueue<U> q2 = this.queue;
        if (this.wip.get() == 0 && this.wip.compareAndSet(0, 1)) {
            long r2 = this.requested.get();
            if (r2 == 0L) {
                this.cancelled = true;
                dispose.dispose();
                s2.onError(new MissingBackpressureException("Could not emit buffer due to lack of requests"));
                return;
            }
            if (q2.isEmpty()) {
                if (this.accept((Yx<? super V>)s2, value) && r2 != Long.MAX_VALUE) {
                    this.produced(1L);
                }
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                q2.offer(value);
            }
        } else {
            q2.offer(value);
            if (!this.enter()) {
                return;
            }
        }
        QueueDrainHelper.drainMaxLoop(q2, s2, delayError, dispose, this);
    }

    @Override
    public boolean accept(Yx<? super V> a2, U v2) {
        return false;
    }

    @Override
    public final Throwable error() {
        return this.error;
    }

    @Override
    public final int leave(int m2) {
        return this.wip.addAndGet(m2);
    }

    @Override
    public final long requested() {
        return this.requested.get();
    }

    @Override
    public final long produced(long n2) {
        return this.requested.addAndGet(-n2);
    }

    public final void requested(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
        }
    }
}

