/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.HalfSerializer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class StrictSubscriber<T>
extends AtomicInteger
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = -4945028590049415624L;
    final Yx<? super T> actual;
    final AtomicThrowable error;
    final AtomicLong requested;
    final AtomicReference<Yy> s;
    final AtomicBoolean once;
    volatile boolean done;

    public StrictSubscriber(Yx<? super T> actual) {
        this.actual = actual;
        this.error = new AtomicThrowable();
        this.requested = new AtomicLong();
        this.s = new AtomicReference();
        this.once = new AtomicBoolean();
    }

    @Override
    public void request(long n2) {
        if (n2 <= 0L) {
            this.cancel();
            this.onError(new IllegalArgumentException("\u00a73.9 violated: positive request amount required but it was " + n2));
        } else {
            SubscriptionHelper.deferredRequest(this.s, this.requested, n2);
        }
    }

    @Override
    public void cancel() {
        if (!this.done) {
            SubscriptionHelper.cancel(this.s);
        }
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (this.once.compareAndSet(false, true)) {
            this.actual.onSubscribe(this);
            SubscriptionHelper.deferredSetOnce(this.s, this.requested, s2);
        } else {
            s2.cancel();
            this.cancel();
            this.onError(new IllegalStateException("\u00a72.12 violated: onSubscribe must be called at most once"));
        }
    }

    @Override
    public void onNext(T t2) {
        HalfSerializer.onNext(this.actual, t2, (AtomicInteger)this, this.error);
    }

    @Override
    public void onError(Throwable t2) {
        this.done = true;
        HalfSerializer.onError(this.actual, t2, (AtomicInteger)this, this.error);
    }

    @Override
    public void onComplete() {
        this.done = true;
        HalfSerializer.onComplete(this.actual, (AtomicInteger)this, this.error);
    }
}

