/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscriptions;

import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class AsyncSubscription
extends AtomicLong
implements Yy,
Disposable {
    private static final long serialVersionUID = 7028635084060361255L;
    final AtomicReference<Yy> actual;
    final AtomicReference<Disposable> resource = new AtomicReference();

    public AsyncSubscription() {
        this.actual = new AtomicReference();
    }

    public AsyncSubscription(Disposable resource) {
        this();
        this.resource.lazySet(resource);
    }

    @Override
    public void request(long n2) {
        SubscriptionHelper.deferredRequest(this.actual, this, n2);
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    @Override
    public void dispose() {
        SubscriptionHelper.cancel(this.actual);
        DisposableHelper.dispose(this.resource);
    }

    @Override
    public boolean isDisposed() {
        return this.actual.get() == SubscriptionHelper.CANCELLED;
    }

    public boolean setResource(Disposable r2) {
        return DisposableHelper.set(this.resource, r2);
    }

    public boolean replaceResource(Disposable r2) {
        return DisposableHelper.replace(this.resource, r2);
    }

    public void setSubscription(Yy s2) {
        SubscriptionHelper.deferredSetOnce(this.actual, this, s2);
    }
}

