/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscriptions;

import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class SubscriptionArbiter
extends AtomicInteger
implements Yy {
    private static final long serialVersionUID = -2189523197179400958L;
    Yy actual;
    long requested;
    final AtomicReference<Yy> missedSubscription = new AtomicReference();
    final AtomicLong missedRequested = new AtomicLong();
    final AtomicLong missedProduced = new AtomicLong();
    volatile boolean cancelled;
    protected boolean unbounded;

    public final void setSubscription(Yy s2) {
        if (this.cancelled) {
            s2.cancel();
            return;
        }
        ObjectHelper.requireNonNull(s2, "s is null");
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            Yy a2 = this.actual;
            if (a2 != null) {
                a2.cancel();
            }
            this.actual = s2;
            long r2 = this.requested;
            if (this.decrementAndGet() != 0) {
                this.drainLoop();
            }
            if (r2 != 0L) {
                s2.request(r2);
            }
            return;
        }
        Yy a3 = this.missedSubscription.getAndSet(s2);
        if (a3 != null) {
            a3.cancel();
        }
        this.drain();
    }

    @Override
    public final void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            if (this.unbounded) {
                return;
            }
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long r2 = this.requested;
                if (r2 != Long.MAX_VALUE) {
                    this.requested = r2 = BackpressureHelper.addCap(r2, n2);
                    if (r2 == Long.MAX_VALUE) {
                        this.unbounded = true;
                    }
                }
                Yy a2 = this.actual;
                if (this.decrementAndGet() != 0) {
                    this.drainLoop();
                }
                if (a2 != null) {
                    a2.request(n2);
                }
                return;
            }
            BackpressureHelper.add(this.missedRequested, n2);
            this.drain();
        }
    }

    public final void produced(long n2) {
        if (this.unbounded) {
            return;
        }
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            long r2 = this.requested;
            if (r2 != Long.MAX_VALUE) {
                long u2 = r2 - n2;
                if (u2 < 0L) {
                    SubscriptionHelper.reportMoreProduced(u2);
                    u2 = 0L;
                }
                this.requested = u2;
            }
            if (this.decrementAndGet() == 0) {
                return;
            }
            this.drainLoop();
            return;
        }
        BackpressureHelper.add(this.missedProduced, n2);
        this.drain();
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.drain();
        }
    }

    final void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        this.drainLoop();
    }

    final void drainLoop() {
        int missed = 1;
        long requestAmount = 0L;
        Yy requestTarget = null;
        do {
            long mp2;
            long mr2;
            Yy ms2;
            if ((ms2 = this.missedSubscription.get()) != null) {
                ms2 = this.missedSubscription.getAndSet(null);
            }
            if ((mr2 = this.missedRequested.get()) != 0L) {
                mr2 = this.missedRequested.getAndSet(0L);
            }
            if ((mp2 = this.missedProduced.get()) != 0L) {
                mp2 = this.missedProduced.getAndSet(0L);
            }
            Yy a2 = this.actual;
            if (this.cancelled) {
                if (a2 != null) {
                    a2.cancel();
                    this.actual = null;
                }
                if (ms2 == null) continue;
                ms2.cancel();
                continue;
            }
            long r2 = this.requested;
            if (r2 != Long.MAX_VALUE) {
                long u2 = BackpressureHelper.addCap(r2, mr2);
                if (u2 != Long.MAX_VALUE) {
                    long v2 = u2 - mp2;
                    if (v2 < 0L) {
                        SubscriptionHelper.reportMoreProduced(v2);
                        v2 = 0L;
                    }
                    r2 = v2;
                } else {
                    r2 = u2;
                }
                this.requested = r2;
            }
            if (ms2 != null) {
                if (a2 != null) {
                    a2.cancel();
                }
                this.actual = ms2;
                if (r2 == 0L) continue;
                requestAmount = BackpressureHelper.addCap(requestAmount, r2);
                requestTarget = ms2;
                continue;
            }
            if (a2 == null || mr2 == 0L) continue;
            requestAmount = BackpressureHelper.addCap(requestAmount, mr2);
            requestTarget = a2;
        } while ((missed = this.addAndGet(-missed)) != 0);
        if (requestAmount != 0L) {
            requestTarget.request(requestAmount);
        }
    }

    public final boolean isUnbounded() {
        return this.unbounded;
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }
}

